package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 批量更新告警规则状态为禁用或启用。 */
public class MonitorChangeAlarmRulesStatusVdaApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorChangeAlarmRulesStatusVdaApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v4.1/monitor/change-alarm-rules-status",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ChangeAlarmRulesStatusVdaResponse send(
            Credential credential, ChangeAlarmRulesStatusVdaRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ChangeAlarmRulesStatusVdaResponse.class);
    }

    public static class ChangeAlarmRulesStatusVdaRequest {
        /** 资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /**
         * 本参数表示告警黑名单状态。取值范围：<br>
         * 0：启用。<br>
         * 1：停用。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("status")
        private Integer status;

        /** 告警规则ID列表 */
        @JsonProperty("alarmRuleIDList")
        private List<String> alarmRuleIDList;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public List<String> getAlarmRuleIDList() {
            return this.alarmRuleIDList;
        }

        public void setAlarmRuleIDList(List<String> alarmRuleIDList) {
            this.alarmRuleIDList = alarmRuleIDList;
        }
    }

    public static class ChangeAlarmRulesStatusVdaResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，一般为中文描述 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 返回参数 */
        @JsonProperty("returnObj")
        private ChangeAlarmRulesStatusVdaReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public ChangeAlarmRulesStatusVdaReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(ChangeAlarmRulesStatusVdaReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class ChangeAlarmRulesStatusVdaReturnObjResponse {
        /** 是否成功 */
        @JsonProperty("success")
        private Boolean success;

        public Boolean getSuccess() {
            return this.success;
        }

        public void setSuccess(Boolean success) {
            this.success = success;
        }
    }
}
