package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 创建一个告警黑名单。 */
public class MonitorCreateAlarmBlacklistApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorCreateAlarmBlacklistApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v4/monitor/create-alarm-blacklist",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public CreateAlarmBlacklistResponse send(
            Credential credential, CreateAlarmBlacklistRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(CreateAlarmBlacklistResponse.class);
    }

    public static class CreateAlarmBlacklistRequest {
        /** ctyun资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 告警黑名单名称 */
        @JsonProperty("name")
        private String name;

        /**
         * 本参数表示服务。取值范围：<br>
         * ecs：云主机。<br>
         * evs：云硬盘。<br>
         * pms：物理机。<br>
         * ...<br>
         * 详见"[云监控：查询服务维度及监控项](https://www.ctyun.cn/document/10032263/10747790)"接口返回。
         */
        @JsonProperty("service")
        private String service;

        /**
         * 本参数表示告警维度。取值范围：<br>
         * ecs：云主机。<br>
         * disk：磁盘。<br>
         * pms：物理机。<br>
         * ...<br>
         * 详见"[云监控：查询服务维度及监控项](https://www.ctyun.cn/document/10032263/10747790)"接口返回。
         */
        @JsonProperty("dimension")
        private String dimension;

        /** 描述 */
        @JsonProperty("desc")
        private String desc;

        /** 资源信息列表 */
        @JsonProperty("resources")
        private List<CreateAlarmBlacklistResourcesRequest> resources;

        /** 联系组列表 */
        @JsonProperty("contactGroupList")
        private List<String> contactGroupList;

        /** 指标列表 */
        @JsonProperty("metrics")
        private List<String> metrics;

        /** 开始时间，秒级时间戳，startTime和endTime需同时传或同时不传。 */
        @JsonProperty("startTime")
        private Integer startTime;

        /** 结束时间，秒级时间戳，配合startTime一起使用，结束时间须大于开始时间。 */
        @JsonProperty("endTime")
        private Integer endTime;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getService() {
            return this.service;
        }

        public void setService(String service) {
            this.service = service;
        }

        public String getDimension() {
            return this.dimension;
        }

        public void setDimension(String dimension) {
            this.dimension = dimension;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public List<CreateAlarmBlacklistResourcesRequest> getResources() {
            return this.resources;
        }

        public void setResources(List<CreateAlarmBlacklistResourcesRequest> resources) {
            this.resources = resources;
        }

        public List<String> getContactGroupList() {
            return this.contactGroupList;
        }

        public void setContactGroupList(List<String> contactGroupList) {
            this.contactGroupList = contactGroupList;
        }

        public List<String> getMetrics() {
            return this.metrics;
        }

        public void setMetrics(List<String> metrics) {
            this.metrics = metrics;
        }

        public Integer getStartTime() {
            return this.startTime;
        }

        public void setStartTime(Integer startTime) {
            this.startTime = startTime;
        }

        public Integer getEndTime() {
            return this.endTime;
        }

        public void setEndTime(Integer endTime) {
            this.endTime = endTime;
        }
    }

    public static class CreateAlarmBlacklistResourcesRequest {
        /** 资源信息 */
        @JsonProperty("resource")
        private List<CreateAlarmBlacklistResourcesResourceRequest> resource;

        public List<CreateAlarmBlacklistResourcesResourceRequest> getResource() {
            return this.resource;
        }

        public void setResource(List<CreateAlarmBlacklistResourcesResourceRequest> resource) {
            this.resource = resource;
        }
    }

    public static class CreateAlarmBlacklistResourcesResourceRequest {
        /** 资源实例标签键 */
        @JsonProperty("name")
        private String name;

        /** 资源实例标签值 */
        @JsonProperty("value")
        private String value;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class CreateAlarmBlacklistResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，一般为中文描述 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 失败时的错误描述，适配中英文 */
        @JsonProperty("description")
        private String description;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private CreateAlarmBlacklistReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public CreateAlarmBlacklistReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(CreateAlarmBlacklistReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class CreateAlarmBlacklistReturnObjResponse {
        /** 告警黑名单ID */
        @JsonProperty("alarmBlacklistID")
        private String alarmBlacklistID;

        public String getAlarmBlacklistID() {
            return this.alarmBlacklistID;
        }

        public void setAlarmBlacklistID(String alarmBlacklistID) {
            this.alarmBlacklistID = alarmBlacklistID;
        }
    }
}
