package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 调用此接口可创建通知模板。 */
public class MonitorCreateNoticeTemplateApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorCreateNoticeTemplateApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v4/monitor/create-notice-template",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public CreateNoticeTemplateResponse send(
            Credential credential, CreateNoticeTemplateRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(CreateNoticeTemplateResponse.class);
    }

    public static class CreateNoticeTemplateRequest {
        /** 通知模板名称 ，长度2-40个字符。 */
        @JsonProperty("name")
        private String name;

        /**
         * 本参数表示服务。取值范围：<br>
         * ecs：云主机。<br>
         * evs：云硬盘。<br>
         * pms：物理机。<br>
         * ...<br>
         * 详见"[云监控：查询服务维度及监控项](https://www.ctyun.cn/document/10032263/10747790)"接口返回。
         */
        @JsonProperty("service")
        private String service;

        /**
         * 本参数表示告警维度。取值范围：<br>
         * ecs：云主机。<br>
         * disk：磁盘。<br>
         * pms：物理机。<br>
         * ...<br>
         * 详见"[云监控：查询服务维度及监控项](https://www.ctyun.cn/document/10032263/10747790)"接口返回。
         */
        @JsonProperty("dimension")
        private String dimension;

        /** 通知模板 */
        @JsonProperty("contents")
        private List<CreateNoticeTemplateContentsRequest> contents;

        /** 是否为自定义默认通知模板，默认值为false */
        @JsonProperty("isDefault")
        private Boolean isDefault;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getService() {
            return this.service;
        }

        public void setService(String service) {
            this.service = service;
        }

        public String getDimension() {
            return this.dimension;
        }

        public void setDimension(String dimension) {
            this.dimension = dimension;
        }

        public List<CreateNoticeTemplateContentsRequest> getContents() {
            return this.contents;
        }

        public void setContents(List<CreateNoticeTemplateContentsRequest> contents) {
            this.contents = contents;
        }

        public Boolean getIsDefault() {
            return this.isDefault;
        }

        public void setIsDefault(Boolean isDefault) {
            this.isDefault = isDefault;
        }
    }

    public static class CreateNoticeTemplateContentsRequest {
        /** 通知模板内容， 长度不能超过400个字符。 */
        @JsonProperty("content")
        private String content;

        /**
         * 本参数表示通知方式。取值范围：<br>
         * sms：短信。<br>
         * email：邮件。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("notifyType")
        private String notifyType;

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public String getNotifyType() {
            return this.notifyType;
        }

        public void setNotifyType(String notifyType) {
            this.notifyType = notifyType;
        }
    }

    public static class CreateNoticeTemplateResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，适配中英文 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 失败时的错误描述，适配中英文 */
        @JsonProperty("description")
        private String description;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        /** 返回参数，参考returnObj对象结构 */
        @JsonProperty("returnObj")
        private CreateNoticeTemplateReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public CreateNoticeTemplateReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(CreateNoticeTemplateReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class CreateNoticeTemplateReturnObjResponse {
        /** 通知模板ID */
        @JsonProperty("noticeTemplateID")
        private String noticeTemplateID;

        public String getNoticeTemplateID() {
            return this.noticeTemplateID;
        }

        public void setNoticeTemplateID(String noticeTemplateID) {
            this.noticeTemplateID = noticeTemplateID;
        }
    }
}
