package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 调用此接口可创建一个资源分组。 */
public class MonitorCreateResGroupV41Api {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorCreateResGroupV41Api(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v4.1/monitor/create-resource-group",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public CreateResGroupV41Response send(Credential credential, CreateResGroupV41Request request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(CreateResGroupV41Response.class);
    }

    public static class CreateResGroupV41Request {
        /** 资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 资源分组名称，长度2-40个字符。 */
        @JsonProperty("name")
        private String name;

        /** 资源分组描述，长度不超过100个字符，默认值为空字符。 */
        @JsonProperty("desc")
        private String desc;

        /**
         * 本参数表示创建方式，默认值：instance。取值范围：<br>
         * instance：实例创建。<br>
         * project：企业项目创建。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("createType")
        private String createType;

        /**
         * 创建方式为实例创建时的资源列表，创建方式（createType）为instance时，resourceList为必填参数，资源列表中的元素resourceListObj的个数不超过20个。
         */
        @JsonProperty("resourceList")
        private List<CreateResGroupV41ResourceListRequest> resourceList;

        /** 创建方式为企业项目创建时的企业项目信息， 创建方式（createType）为project时，projectInfo为必填参数。 */
        @JsonProperty("projectInfo")
        private CreateResGroupV41ProjectInfoRequest projectInfo;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public String getCreateType() {
            return this.createType;
        }

        public void setCreateType(String createType) {
            this.createType = createType;
        }

        public List<CreateResGroupV41ResourceListRequest> getResourceList() {
            return this.resourceList;
        }

        public void setResourceList(List<CreateResGroupV41ResourceListRequest> resourceList) {
            this.resourceList = resourceList;
        }

        public CreateResGroupV41ProjectInfoRequest getProjectInfo() {
            return this.projectInfo;
        }

        public void setProjectInfo(CreateResGroupV41ProjectInfoRequest projectInfo) {
            this.projectInfo = projectInfo;
        }
    }

    public static class CreateResGroupV41ResourceListRequest {
        /** 云监控服务，具体服务参见[云监控：查询服务维度及监控项](https://www.ctyun.cn/document/10032263/10747790) */
        @JsonProperty("service")
        private String service;

        /** 云监控维度，具体维度参见[云监控：查询服务维度及监控项](https://www.ctyun.cn/document/10032263/10747790) */
        @JsonProperty("dimension")
        private String dimension;

        /** 资源信息列表 */
        @JsonProperty("resources")
        private List<CreateResGroupV41ResourceListResourcesRequest> resources;

        public String getService() {
            return this.service;
        }

        public void setService(String service) {
            this.service = service;
        }

        public String getDimension() {
            return this.dimension;
        }

        public void setDimension(String dimension) {
            this.dimension = dimension;
        }

        public List<CreateResGroupV41ResourceListResourcesRequest> getResources() {
            return this.resources;
        }

        public void setResources(List<CreateResGroupV41ResourceListResourcesRequest> resources) {
            this.resources = resources;
        }
    }

    public static class CreateResGroupV41ProjectInfoRequest {
        /** 企业项目ID */
        @JsonProperty("projectID")
        private String projectID;

        /** 企业项目产品列表 */
        @JsonProperty("projectProducts")
        private List<CreateResGroupV41ProjectInfoProjectProductsRequest> projectProducts;

        public String getProjectID() {
            return this.projectID;
        }

        public void setProjectID(String projectID) {
            this.projectID = projectID;
        }

        public List<CreateResGroupV41ProjectInfoProjectProductsRequest> getProjectProducts() {
            return this.projectProducts;
        }

        public void setProjectProducts(
                List<CreateResGroupV41ProjectInfoProjectProductsRequest> projectProducts) {
            this.projectProducts = projectProducts;
        }
    }

    public static class CreateResGroupV41ResourceListResourcesRequest {
        /** 资源信息 */
        @JsonProperty("resource")
        private List<CreateResGroupV41ResourceListResourcesResourceRequest> resource;

        public List<CreateResGroupV41ResourceListResourcesResourceRequest> getResource() {
            return this.resource;
        }

        public void setResource(
                List<CreateResGroupV41ResourceListResourcesResourceRequest> resource) {
            this.resource = resource;
        }
    }

    public static class CreateResGroupV41ProjectInfoProjectProductsRequest {
        /**
         * 本参数表示服务。取值范围：<br>
         * ecs：云主机。<br>
         * evs：云硬盘。<br>
         * pms：物理机。<br>
         * ...<br>
         * 详见“[告警规则：获取告警服务列表](https://www.ctyun.cn/document/10032263/10040008)”接口返回。
         */
        @JsonProperty("service")
        private String service;

        /**
         * 本参数表示告警维度。取值范围：<br>
         * ecs：云主机。<br>
         * disk：磁盘。<br>
         * pms：物理机。<br>
         * ...<br>
         * 详见“[告警规则：获取告警服务维度关系](https://www.ctyun.cn/document/10032263/10040009)”接口返回。
         */
        @JsonProperty("dimension")
        private String dimension;

        public String getService() {
            return this.service;
        }

        public void setService(String service) {
            this.service = service;
        }

        public String getDimension() {
            return this.dimension;
        }

        public void setDimension(String dimension) {
            this.dimension = dimension;
        }
    }

    public static class CreateResGroupV41ResourceListResourcesResourceRequest {
        /** 实例标签名 */
        @JsonProperty("name")
        private String name;

        /** 实例标签对应的值，无效值将无法正常产生告警。 */
        @JsonProperty("value")
        private String value;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class CreateResGroupV41Response {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，适配中英文 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 失败时的错误描述，适配中英文 */
        @JsonProperty("description")
        private String description;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        /** 返回参数 */
        @JsonProperty("returnObj")
        private CreateResGroupV41ReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public CreateResGroupV41ReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(CreateResGroupV41ReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class CreateResGroupV41ReturnObjResponse {
        /** 资源分组ID */
        @JsonProperty("resGroupID")
        private String resGroupID;

        public String getResGroupID() {
            return this.resGroupID;
        }

        public void setResGroupID(String resGroupID) {
            this.resGroupID = resGroupID;
        }
    }
}
