package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 调用此接口可查询告警联系人组的配置详情。 */
public class MonitorDescribeContactGroupApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorDescribeContactGroupApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v4/monitor/describe-contact-group",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public DescribeContactGroupResponse send(
            Credential credential, DescribeContactGroupRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.contactGroupID != null) {
            ctReq.addParam("contactGroupID", request.contactGroupID);
            request.contactGroupID = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(DescribeContactGroupResponse.class);
    }

    public static class DescribeContactGroupRequest {
        /** 告警联系人组ID */
        @JsonProperty("contactGroupID")
        private String contactGroupID;

        public String getContactGroupID() {
            return this.contactGroupID;
        }

        public void setContactGroupID(String contactGroupID) {
            this.contactGroupID = contactGroupID;
        }
    }

    public static class DescribeContactGroupResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，一般为中文描述 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 返回参数 */
        @JsonProperty("returnObj")
        private DescribeContactGroupReturnObjResponse returnObj;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public DescribeContactGroupReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(DescribeContactGroupReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class DescribeContactGroupReturnObjResponse {
        /** 告警联系人组ID */
        @JsonProperty("contactGroupID")
        private String contactGroupID;

        /** 组名 */
        @JsonProperty("name")
        private String name;

        /** 组备注 */
        @JsonProperty("desc")
        private String desc;

        /** 告警联系人列表 */
        @JsonProperty("contactList")
        private List<DescribeContactGroupReturnObjContactListResponse> contactList;

        /** 最近更新时间, 时间戳，精确到毫秒 */
        @JsonProperty("updateTime")
        private Integer updateTime;

        /** 创建时间，时间戳，精确到毫秒 */
        @JsonProperty("createTime")
        private Integer createTime;

        public String getContactGroupID() {
            return this.contactGroupID;
        }

        public void setContactGroupID(String contactGroupID) {
            this.contactGroupID = contactGroupID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public List<DescribeContactGroupReturnObjContactListResponse> getContactList() {
            return this.contactList;
        }

        public void setContactList(
                List<DescribeContactGroupReturnObjContactListResponse> contactList) {
            this.contactList = contactList;
        }

        public Integer getUpdateTime() {
            return this.updateTime;
        }

        public void setUpdateTime(Integer updateTime) {
            this.updateTime = updateTime;
        }

        public Integer getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(Integer createTime) {
            this.createTime = createTime;
        }
    }

    public static class DescribeContactGroupReturnObjContactListResponse {
        /** 告警联系人ID */
        @JsonProperty("contactID")
        private String contactID;

        /** 用户名 */
        @JsonProperty("name")
        private String name;

        /** 手机号 */
        @JsonProperty("phone")
        private String phone;

        /** 邮箱 */
        @JsonProperty("email")
        private String email;

        /**
         * 本参数表示手机号码是否激活。取值范围：<br>
         * 1：已激活。<br>
         * 0：未激活。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("phoneActivation")
        private Integer phoneActivation;

        /**
         * 本参数表示邮箱是否激活。取值范围：<br>
         * 1：已激活。<br>
         * 0：未激活。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("emailActivation")
        private Integer emailActivation;

        public String getContactID() {
            return this.contactID;
        }

        public void setContactID(String contactID) {
            this.contactID = contactID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPhone() {
            return this.phone;
        }

        public void setPhone(String phone) {
            this.phone = phone;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public Integer getPhoneActivation() {
            return this.phoneActivation;
        }

        public void setPhoneActivation(Integer phoneActivation) {
            this.phoneActivation = phoneActivation;
        }

        public Integer getEmailActivation() {
            return this.emailActivation;
        }

        public void setEmailActivation(Integer emailActivation) {
            this.emailActivation = emailActivation;
        }
    }
}
