package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查看自定义监控告警规则的详情信息。 */
public class MonitorDescribeCustomAlarmRuleApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorDescribeCustomAlarmRuleApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v4/monitor/describe-custom-alarm-rule",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public DescribeCustomAlarmRuleResponse send(
            Credential credential, DescribeCustomAlarmRuleRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionID != null) {
            ctReq.addParam("regionID", request.regionID);
            request.regionID = null;
        }
        if (request.alarmRuleID != null) {
            ctReq.addParam("alarmRuleID", request.alarmRuleID);
            request.alarmRuleID = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(DescribeCustomAlarmRuleResponse.class);
    }

    public static class DescribeCustomAlarmRuleRequest {
        /** ctyun资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 告警规则ID */
        @JsonProperty("alarmRuleID")
        private String alarmRuleID;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getAlarmRuleID() {
            return this.alarmRuleID;
        }

        public void setAlarmRuleID(String alarmRuleID) {
            this.alarmRuleID = alarmRuleID;
        }
    }

    public static class DescribeCustomAlarmRuleResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，一般为中文描述 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private DescribeCustomAlarmRuleReturnObjResponse returnObj;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public DescribeCustomAlarmRuleReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(DescribeCustomAlarmRuleReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class DescribeCustomAlarmRuleReturnObjResponse {
        /** ctyun资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 告警规则ID */
        @JsonProperty("alarmRuleID")
        private String alarmRuleID;

        /** 规则名 */
        @JsonProperty("name")
        private String name;

        /** 描述 */
        @JsonProperty("desc")
        private String desc;

        /** 重复告警通知次数 */
        @JsonProperty("repeatTimes")
        private Integer repeatTimes;

        /** 静默时间，单位：秒 */
        @JsonProperty("silenceTime")
        private Integer silenceTime;

        /**
         * 本参数表示恢复是否通知。默认值0。取值范围：<br>
         * 0：否。<br>
         * 1：是。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("recoverNotify")
        private Integer recoverNotify;

        /** 告警接收策略 */
        @JsonProperty("notifyType")
        private List<String> notifyType;

        /** 告警联系人组 */
        @JsonProperty("contactGroupList")
        private List<String> contactGroupList;

        /** 通知周期 */
        @JsonProperty("notifyWeekdays")
        private List<Integer> notifyWeekdays;

        /** 通知起始时段 */
        @JsonProperty("notifyStart")
        private String notifyStart;

        /** 通知结束时段 */
        @JsonProperty("notifyEnd")
        private String notifyEnd;

        /** 持续周期数，默认2次 */
        @JsonProperty("evaluationCount")
        private Integer evaluationCount;

        /** ITEM63cb8954325480a3202307071801 */
        @JsonProperty("customItemID")
        private String customItemID;

        /**
         * 本参数表示告警采用算法。取值范围：<br>
         * last：原始值算法。<br>
         * avg：平均值算法。<br>
         * max：最大值算法。<br>
         * min：最小值算法。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("fun")
        private String fun;

        /**
         * 本参数表示比较符。默认值le。取值范围：<br>
         * eq：等于。<br>
         * gt：大于。<br>
         * ge：大于等于。<br>
         * lt：小于。<br>
         * le：小于等于。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("operator")
        private String operator;

        /** 告警阈值，可以是整数、小数或百分数格式字符串 */
        @JsonProperty("value")
        private String value;

        /**
         * 本参数表示算法统计周期。默认值5m。<br>
         * 参数fun为last时不可传。<br>
         * 参数fun为avg、max、min均需填此参数。<br>
         * 本参数格式为“数字+单位”。单位取值范围：<br>
         * m：分钟。<br>
         * h：小时。<br>
         * d：天。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("period")
        private String period;

        /** 自定义监控项维度 */
        @JsonProperty("dimensions")
        private List<DescribeCustomAlarmRuleReturnObjDimensionsResponse> dimensions;

        /**
         * 本参数表示告警规则启用状态。取值范围：<br>
         * 0：启用。<br>
         * 1：停用。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("status")
        private Integer status;

        /**
         * 本参数表示告警规则告警状态。取值范围：<br>
         * 0：正常。<br>
         * 1：正在告警。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("alarmStatus")
        private Integer alarmStatus;

        /** 创建时间 */
        @JsonProperty("createTime")
        private Integer createTime;

        /** 更新时间 */
        @JsonProperty("updateTime")
        private Integer updateTime;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getAlarmRuleID() {
            return this.alarmRuleID;
        }

        public void setAlarmRuleID(String alarmRuleID) {
            this.alarmRuleID = alarmRuleID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public Integer getRepeatTimes() {
            return this.repeatTimes;
        }

        public void setRepeatTimes(Integer repeatTimes) {
            this.repeatTimes = repeatTimes;
        }

        public Integer getSilenceTime() {
            return this.silenceTime;
        }

        public void setSilenceTime(Integer silenceTime) {
            this.silenceTime = silenceTime;
        }

        public Integer getRecoverNotify() {
            return this.recoverNotify;
        }

        public void setRecoverNotify(Integer recoverNotify) {
            this.recoverNotify = recoverNotify;
        }

        public List<String> getNotifyType() {
            return this.notifyType;
        }

        public void setNotifyType(List<String> notifyType) {
            this.notifyType = notifyType;
        }

        public List<String> getContactGroupList() {
            return this.contactGroupList;
        }

        public void setContactGroupList(List<String> contactGroupList) {
            this.contactGroupList = contactGroupList;
        }

        public List<Integer> getNotifyWeekdays() {
            return this.notifyWeekdays;
        }

        public void setNotifyWeekdays(List<Integer> notifyWeekdays) {
            this.notifyWeekdays = notifyWeekdays;
        }

        public String getNotifyStart() {
            return this.notifyStart;
        }

        public void setNotifyStart(String notifyStart) {
            this.notifyStart = notifyStart;
        }

        public String getNotifyEnd() {
            return this.notifyEnd;
        }

        public void setNotifyEnd(String notifyEnd) {
            this.notifyEnd = notifyEnd;
        }

        public Integer getEvaluationCount() {
            return this.evaluationCount;
        }

        public void setEvaluationCount(Integer evaluationCount) {
            this.evaluationCount = evaluationCount;
        }

        public String getCustomItemID() {
            return this.customItemID;
        }

        public void setCustomItemID(String customItemID) {
            this.customItemID = customItemID;
        }

        public String getFun() {
            return this.fun;
        }

        public void setFun(String fun) {
            this.fun = fun;
        }

        public String getOperator() {
            return this.operator;
        }

        public void setOperator(String operator) {
            this.operator = operator;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getPeriod() {
            return this.period;
        }

        public void setPeriod(String period) {
            this.period = period;
        }

        public List<DescribeCustomAlarmRuleReturnObjDimensionsResponse> getDimensions() {
            return this.dimensions;
        }

        public void setDimensions(
                List<DescribeCustomAlarmRuleReturnObjDimensionsResponse> dimensions) {
            this.dimensions = dimensions;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public Integer getAlarmStatus() {
            return this.alarmStatus;
        }

        public void setAlarmStatus(Integer alarmStatus) {
            this.alarmStatus = alarmStatus;
        }

        public Integer getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(Integer createTime) {
            this.createTime = createTime;
        }

        public Integer getUpdateTime() {
            return this.updateTime;
        }

        public void setUpdateTime(Integer updateTime) {
            this.updateTime = updateTime;
        }
    }

    public static class DescribeCustomAlarmRuleReturnObjDimensionsResponse {
        /** 维度名称 */
        @JsonProperty("name")
        private String name;

        /** 维度值 */
        @JsonProperty("value")
        private List<String> value;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<String> getValue() {
            return this.value;
        }

        public void setValue(List<String> value) {
            this.value = value;
        }
    }
}
