package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询指定设备的实时监控数据。 */
public class MonitorDescribeLatestMetricDataVdbApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorDescribeLatestMetricDataVdbApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v4.2/monitor/query-latest-metric-data",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public DescribeLatestMetricDataVdbResponse send(
            Credential credential, DescribeLatestMetricDataVdbRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(DescribeLatestMetricDataVdbResponse.class);
    }

    public static class DescribeLatestMetricDataVdbRequest {
        /** 资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 云监控服务，具体服务参见[云监控：查询服务维度及监控项](https://www.ctyun.cn/document/10032263/10747790) */
        @JsonProperty("service")
        private String service;

        /** 云监控维度，具体维度参见[云监控：查询服务维度及监控项](https://www.ctyun.cn/document/10032263/10747790) */
        @JsonProperty("dimension")
        private String dimension;

        /**
         * 待查监控项名称，单次请求长度限制为10，具体设备对应监控项参见[云监控：查询服务维度及监控项](https://www.ctyun.cn/document/10032263/10747790)
         */
        @JsonProperty("itemNameList")
        private List<String> itemNameList;

        /** 查询设备标签列表，用于定位要查询监控数据的目标设备，多标签查询取交集，单次请求设备数量限制为10 */
        @JsonProperty("dimensions")
        private List<DescribeLatestMetricDataVdbDimensionsRequest> dimensions;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getService() {
            return this.service;
        }

        public void setService(String service) {
            this.service = service;
        }

        public String getDimension() {
            return this.dimension;
        }

        public void setDimension(String dimension) {
            this.dimension = dimension;
        }

        public List<String> getItemNameList() {
            return this.itemNameList;
        }

        public void setItemNameList(List<String> itemNameList) {
            this.itemNameList = itemNameList;
        }

        public List<DescribeLatestMetricDataVdbDimensionsRequest> getDimensions() {
            return this.dimensions;
        }

        public void setDimensions(List<DescribeLatestMetricDataVdbDimensionsRequest> dimensions) {
            this.dimensions = dimensions;
        }
    }

    public static class DescribeLatestMetricDataVdbDimensionsRequest {
        /**
         * 设备标签键，取值范围参考[云监控：查询服务维度及监控项](https://www.ctyun.cn/document/10032263/10747790)响应的dimensions字段。
         * <br>
         * 以云主机为例，该字段为uuid。
         */
        @JsonProperty("name")
        private String name;

        /**
         * 设备标签键所对应的值，最大数量限制为10。<br>
         * 以云主机为例，该字段为云主机的instanceID。
         */
        @JsonProperty("value")
        private List<String> value;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<String> getValue() {
            return this.value;
        }

        public void setValue(List<String> value) {
            this.value = value;
        }
    }

    public static class DescribeLatestMetricDataVdbResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，一般为中文描述 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private DescribeLatestMetricDataVdbReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public DescribeLatestMetricDataVdbReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(DescribeLatestMetricDataVdbReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class DescribeLatestMetricDataVdbReturnObjResponse {
        /** 监控项数据 */
        @JsonProperty("itemList")
        private List<DescribeLatestMetricDataVdbReturnObjItemListResponse> itemList;

        public List<DescribeLatestMetricDataVdbReturnObjItemListResponse> getItemList() {
            return this.itemList;
        }

        public void setItemList(
                List<DescribeLatestMetricDataVdbReturnObjItemListResponse> itemList) {
            this.itemList = itemList;
        }
    }

    public static class DescribeLatestMetricDataVdbReturnObjItemListResponse {
        /** 监控项名称，具体设备对应监控项参见[云监控：查询服务维度及监控项](https://www.ctyun.cn/document/10032263/10747790) */
        @JsonProperty("itemName")
        private String itemName;

        /** 监控项中文介绍 */
        @JsonProperty("itemDesc")
        private String itemDesc;

        /** 监控项单位 */
        @JsonProperty("itemUnit")
        private String itemUnit;

        /** 监控项值，具体请参考对应监控项文档 */
        @JsonProperty("value")
        private Float value;

        /** 监控数据采样Unix时间戳 */
        @JsonProperty("timestamp")
        private Integer timestamp;

        /** 监控项标签 */
        @JsonProperty("dimensions")
        private List<DescribeLatestMetricDataVdbReturnObjItemListDimensionsResponse> dimensions;

        public String getItemName() {
            return this.itemName;
        }

        public void setItemName(String itemName) {
            this.itemName = itemName;
        }

        public String getItemDesc() {
            return this.itemDesc;
        }

        public void setItemDesc(String itemDesc) {
            this.itemDesc = itemDesc;
        }

        public String getItemUnit() {
            return this.itemUnit;
        }

        public void setItemUnit(String itemUnit) {
            this.itemUnit = itemUnit;
        }

        public Float getValue() {
            return this.value;
        }

        public void setValue(Float value) {
            this.value = value;
        }

        public Integer getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(Integer timestamp) {
            this.timestamp = timestamp;
        }

        public List<DescribeLatestMetricDataVdbReturnObjItemListDimensionsResponse>
                getDimensions() {
            return this.dimensions;
        }

        public void setDimensions(
                List<DescribeLatestMetricDataVdbReturnObjItemListDimensionsResponse> dimensions) {
            this.dimensions = dimensions;
        }
    }

    public static class DescribeLatestMetricDataVdbReturnObjItemListDimensionsResponse {
        /** 监控项标签键 */
        @JsonProperty("name")
        private String name;

        /** 监控项标签键对应的值 */
        @JsonProperty("value")
        private String value;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}
