package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 调用此接口可查看探测节点的配置详情。 */
public class MonitorDescribeProbePointApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorDescribeProbePointApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v4/monitor/describe-probe-point",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public DescribeProbePointResponse send(Credential credential, DescribeProbePointRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.name != null) {
            ctReq.addParam("name", request.name);
            request.name = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(DescribeProbePointResponse.class);
    }

    public static class DescribeProbePointRequest {
        /** 探测节点名称 */
        @JsonProperty("name")
        private String name;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static class DescribeProbePointResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，一般为中文描述 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 返回参数 */
        @JsonProperty("returnObj")
        private DescribeProbePointReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public DescribeProbePointReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(DescribeProbePointReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class DescribeProbePointReturnObjResponse {
        /** 数据库ID */
        @JsonProperty("mongoID")
        private String mongoID;

        /** 探测节点唯一ID */
        @JsonProperty("ID")
        private String iD;

        /** 探测节点名称 */
        @JsonProperty("name")
        private String name;

        /** region名称 */
        @JsonProperty("hermesRegion")
        private String hermesRegion;

        /** 探测节点区域 */
        @JsonProperty("position")
        private String position;

        /** 探测节点是否可用 */
        @JsonProperty("status")
        private Boolean status;

        public String getMongoID() {
            return this.mongoID;
        }

        public void setMongoID(String mongoID) {
            this.mongoID = mongoID;
        }

        public String getID() {
            return this.iD;
        }

        public void setID(String iD) {
            this.iD = iD;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getHermesRegion() {
            return this.hermesRegion;
        }

        public void setHermesRegion(String hermesRegion) {
            this.hermesRegion = hermesRegion;
        }

        public String getPosition() {
            return this.position;
        }

        public void setPosition(String position) {
            this.position = position;
        }

        public Boolean getStatus() {
            return this.status;
        }

        public void setStatus(Boolean status) {
            this.status = status;
        }
    }
}
