package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 调用此接口可查询指定资源分组详情。 */
public class MonitorDescribeResGroupV41Api {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorDescribeResGroupV41Api(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v4.1/monitor/describe-resource-group",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public DescribeResGroupV41Response send(
            Credential credential, DescribeResGroupV41Request request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.resGroupID != null) {
            ctReq.addParam("resGroupID", request.resGroupID);
            request.resGroupID = null;
        }
        if (request.service != null) {
            ctReq.addParam("service", request.service);
            request.service = null;
        }
        if (request.dimension != null) {
            ctReq.addParam("dimension", request.dimension);
            request.dimension = null;
        }
        if (request.instance != null) {
            ctReq.addParam("instance", request.instance);
            request.instance = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(DescribeResGroupV41Response.class);
    }

    public static class DescribeResGroupV41Request {
        /** 资源分组ID */
        @JsonProperty("resGroupID")
        private String resGroupID;

        /** 云监控服务，具体服务参见[云监控：查询服务维度及监控项](https://www.ctyun.cn/document/10032263/10747790) */
        @JsonProperty("service")
        private String service;

        /** 云监控维度，具体维度参见[云监控：查询服务维度及监控项](https://www.ctyun.cn/document/10032263/10747790) */
        @JsonProperty("dimension")
        private String dimension;

        /** 对resource.value具体资源进行模糊查询 */
        @JsonProperty("instance")
        private String instance;

        public String getResGroupID() {
            return this.resGroupID;
        }

        public void setResGroupID(String resGroupID) {
            this.resGroupID = resGroupID;
        }

        public String getService() {
            return this.service;
        }

        public void setService(String service) {
            this.service = service;
        }

        public String getDimension() {
            return this.dimension;
        }

        public void setDimension(String dimension) {
            this.dimension = dimension;
        }

        public String getInstance() {
            return this.instance;
        }

        public void setInstance(String instance) {
            this.instance = instance;
        }
    }

    public static class DescribeResGroupV41Response {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，适配中英文 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 失败时的错误描述，适配中英文 */
        @JsonProperty("description")
        private String description;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        /** 返回参数 */
        @JsonProperty("returnObj")
        private DescribeResGroupV41ReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public DescribeResGroupV41ReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(DescribeResGroupV41ReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class DescribeResGroupV41ReturnObjResponse {
        /** 资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 资源分组ID */
        @JsonProperty("resGroupID")
        private String resGroupID;

        /**
         * 本参数表示创建方式。取值范围：<br>
         * instance：实例创建。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("createType")
        private String createType;

        /** 名称 */
        @JsonProperty("name")
        private String name;

        /** 描述 */
        @JsonProperty("desc")
        private String desc;

        /**
         * 本参数表示状态。取值范围：<br>
         * 0：未配置告警规则。<br>
         * 1：有告警规则但未告警。<br>
         * 2：告警中。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("alarmStatus")
        private Integer alarmStatus;

        /** 最近更新时间，时间戳，秒级 */
        @JsonProperty("updateTime")
        private Integer updateTime;

        /** 创建时间，时间戳，秒级 */
        @JsonProperty("createTime")
        private Integer createTime;

        /** 创建方式为实例创建时的资源列表 */
        @JsonProperty("resourceList")
        private List<DescribeResGroupV41ReturnObjResourceListResponse> resourceList;

        /** 创建方式为企业项目创建时的企业项目信息 */
        @JsonProperty("projectInfo")
        private DescribeResGroupV41ReturnObjProjectInfoResponse projectInfo;

        /** 资源分组的告警资源总数 */
        @JsonProperty("totalAlarm")
        private Integer totalAlarm;

        /** 资源分组的规则数 */
        @JsonProperty("totalRule")
        private Integer totalRule;

        /** 资源分组的的资源总数 */
        @JsonProperty("totalResource")
        private Integer totalResource;

        /** 资源分组的资源类型数 */
        @JsonProperty("totalResourceType")
        private Integer totalResourceType;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getResGroupID() {
            return this.resGroupID;
        }

        public void setResGroupID(String resGroupID) {
            this.resGroupID = resGroupID;
        }

        public String getCreateType() {
            return this.createType;
        }

        public void setCreateType(String createType) {
            this.createType = createType;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public Integer getAlarmStatus() {
            return this.alarmStatus;
        }

        public void setAlarmStatus(Integer alarmStatus) {
            this.alarmStatus = alarmStatus;
        }

        public Integer getUpdateTime() {
            return this.updateTime;
        }

        public void setUpdateTime(Integer updateTime) {
            this.updateTime = updateTime;
        }

        public Integer getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(Integer createTime) {
            this.createTime = createTime;
        }

        public List<DescribeResGroupV41ReturnObjResourceListResponse> getResourceList() {
            return this.resourceList;
        }

        public void setResourceList(
                List<DescribeResGroupV41ReturnObjResourceListResponse> resourceList) {
            this.resourceList = resourceList;
        }

        public DescribeResGroupV41ReturnObjProjectInfoResponse getProjectInfo() {
            return this.projectInfo;
        }

        public void setProjectInfo(DescribeResGroupV41ReturnObjProjectInfoResponse projectInfo) {
            this.projectInfo = projectInfo;
        }

        public Integer getTotalAlarm() {
            return this.totalAlarm;
        }

        public void setTotalAlarm(Integer totalAlarm) {
            this.totalAlarm = totalAlarm;
        }

        public Integer getTotalRule() {
            return this.totalRule;
        }

        public void setTotalRule(Integer totalRule) {
            this.totalRule = totalRule;
        }

        public Integer getTotalResource() {
            return this.totalResource;
        }

        public void setTotalResource(Integer totalResource) {
            this.totalResource = totalResource;
        }

        public Integer getTotalResourceType() {
            return this.totalResourceType;
        }

        public void setTotalResourceType(Integer totalResourceType) {
            this.totalResourceType = totalResourceType;
        }
    }

    public static class DescribeResGroupV41ReturnObjResourceListResponse {
        /** 云监控服务，具体服务参见[云监控：查询服务维度及监控项](https://www.ctyun.cn/document/10032263/10747790) */
        @JsonProperty("service")
        private String service;

        /** 云监控维度，具体维度参见[云监控：查询服务维度及监控项](https://www.ctyun.cn/document/10032263/10747790) */
        @JsonProperty("dimension")
        private String dimension;

        /** 某一类型下资源总数 */
        @JsonProperty("resourcesTotal")
        private Integer resourcesTotal;

        /** 某一类型下告警中的资源总数 */
        @JsonProperty("alarmNum")
        private Integer alarmNum;

        /** 资源信息列表 */
        @JsonProperty("resources")
        private List<DescribeResGroupV41ReturnObjResourceListResourcesResponse> resources;

        public String getService() {
            return this.service;
        }

        public void setService(String service) {
            this.service = service;
        }

        public String getDimension() {
            return this.dimension;
        }

        public void setDimension(String dimension) {
            this.dimension = dimension;
        }

        public Integer getResourcesTotal() {
            return this.resourcesTotal;
        }

        public void setResourcesTotal(Integer resourcesTotal) {
            this.resourcesTotal = resourcesTotal;
        }

        public Integer getAlarmNum() {
            return this.alarmNum;
        }

        public void setAlarmNum(Integer alarmNum) {
            this.alarmNum = alarmNum;
        }

        public List<DescribeResGroupV41ReturnObjResourceListResourcesResponse> getResources() {
            return this.resources;
        }

        public void setResources(
                List<DescribeResGroupV41ReturnObjResourceListResourcesResponse> resources) {
            this.resources = resources;
        }
    }

    public static class DescribeResGroupV41ReturnObjProjectInfoResponse {
        /** 企业项目ID */
        @JsonProperty("projectID")
        private String projectID;

        /** 企业项目产品列表 */
        @JsonProperty("projectProducts")
        private List<DescribeResGroupV41ReturnObjProjectInfoProjectProductsResponse>
                projectProducts;

        public String getProjectID() {
            return this.projectID;
        }

        public void setProjectID(String projectID) {
            this.projectID = projectID;
        }

        public List<DescribeResGroupV41ReturnObjProjectInfoProjectProductsResponse>
                getProjectProducts() {
            return this.projectProducts;
        }

        public void setProjectProducts(
                List<DescribeResGroupV41ReturnObjProjectInfoProjectProductsResponse>
                        projectProducts) {
            this.projectProducts = projectProducts;
        }
    }

    public static class DescribeResGroupV41ReturnObjResourceListResourcesResponse {
        /** 资源信息 */
        @JsonProperty("resource")
        private List<DescribeResGroupV41ReturnObjResourceListResourcesResourceResponse> resource;

        /**
         * 本参数表示具体资源是否告警。取值范围：<br>
         * 0：正常。<br>
         * 1：告警。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("status")
        private Integer status;

        public List<DescribeResGroupV41ReturnObjResourceListResourcesResourceResponse>
                getResource() {
            return this.resource;
        }

        public void setResource(
                List<DescribeResGroupV41ReturnObjResourceListResourcesResourceResponse> resource) {
            this.resource = resource;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }
    }

    public static class DescribeResGroupV41ReturnObjProjectInfoProjectProductsResponse {
        /**
         * 本参数表示服务。取值范围：<br>
         * ecs：云主机。<br>
         * evs：云硬盘。<br>
         * pms：物理机。<br>
         * ...<br>
         * 详见“[告警规则：获取告警服务列表](https://www.ctyun.cn/document/10032263/10040008)”接口返回。
         */
        @JsonProperty("service")
        private String service;

        /**
         * 本参数表示告警维度。取值范围：<br>
         * ecs：云主机。<br>
         * disk：磁盘。<br>
         * pms：物理机。<br>
         * ...<br>
         * 详见“[告警规则：获取告警服务维度关系](https://www.ctyun.cn/document/10032263/10040009)”接口返回。
         */
        @JsonProperty("dimension")
        private String dimension;

        public String getService() {
            return this.service;
        }

        public void setService(String service) {
            this.service = service;
        }

        public String getDimension() {
            return this.dimension;
        }

        public void setDimension(String dimension) {
            this.dimension = dimension;
        }
    }

    public static class DescribeResGroupV41ReturnObjResourceListResourcesResourceResponse {
        /** 实例标签名 */
        @JsonProperty("name")
        private String name;

        /** 实例标签对应的值，无效值将无法正常产生告警。 */
        @JsonProperty("value")
        private String value;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}
