package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查看告警规则的详情信息。 */
public class MonitorDescribealarmRuleVdaApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorDescribealarmRuleVdaApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v4.1/monitor/describe-alarm-rule",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public DescribealarmRuleVdaResponse send(
            Credential credential, DescribealarmRuleVdaRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionID != null) {
            ctReq.addParam("regionID", request.regionID);
            request.regionID = null;
        }
        if (request.alarmRuleID != null) {
            ctReq.addParam("alarmRuleID", request.alarmRuleID);
            request.alarmRuleID = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(DescribealarmRuleVdaResponse.class);
    }

    public static class DescribealarmRuleVdaRequest {
        /** 资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 告警规则ID */
        @JsonProperty("alarmRuleID")
        private String alarmRuleID;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getAlarmRuleID() {
            return this.alarmRuleID;
        }

        public void setAlarmRuleID(String alarmRuleID) {
            this.alarmRuleID = alarmRuleID;
        }
    }

    public static class DescribealarmRuleVdaResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，一般为中文描述 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private DescribealarmRuleVdaReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public DescribealarmRuleVdaReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(DescribealarmRuleVdaReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class DescribealarmRuleVdaReturnObjResponse {
        /** 告警规则 */
        @JsonProperty("alarmRule")
        private DescribealarmRuleVdaReturnObjAlarmRuleResponse alarmRule;

        public DescribealarmRuleVdaReturnObjAlarmRuleResponse getAlarmRule() {
            return this.alarmRule;
        }

        public void setAlarmRule(DescribealarmRuleVdaReturnObjAlarmRuleResponse alarmRule) {
            this.alarmRule = alarmRule;
        }
    }

    public static class DescribealarmRuleVdaReturnObjAlarmRuleResponse {
        /** 资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 告警规则ID */
        @JsonProperty("alarmRuleID")
        private String alarmRuleID;

        /** 规则名 */
        @JsonProperty("name")
        private String name;

        /** 描述 */
        @JsonProperty("desc")
        private String desc;

        /** 重复告警通知次数 */
        @JsonProperty("repeatTimes")
        private Integer repeatTimes;

        /** 服务 */
        @JsonProperty("service")
        private String service;

        /** 维度 */
        @JsonProperty("dimension")
        private String dimension;

        /** 静默时间，单位：秒 */
        @JsonProperty("silenceTime")
        private Integer silenceTime;

        /**
         * 本参数表示恢复是否通知。取值范围：<br>
         * 0：否。<br>
         * 1：是。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("recoverNotify")
        private Integer recoverNotify;

        /**
         * 本参数表示告警接收策略。取值范围：<br>
         * email：邮件告警。<br>
         * sms：短信告警。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("notifyType")
        private List<String> notifyType;

        /** 告警联系组 */
        @JsonProperty("contactGroupList")
        private List<DescribealarmRuleVdaReturnObjAlarmRuleContactGroupListResponse>
                contactGroupList;

        /**
         * 本参数表示通知周期。取值范围：<br>
         * 0：周日。<br>
         * 1：周一。<br>
         * 2：周二。<br>
         * 3：周三。<br>
         * 4：周四。<br>
         * 5：周五。<br>
         * 6：周六。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("notifyWeekdays")
        private List<Integer> notifyWeekdays;

        /** 通知起始时段 */
        @JsonProperty("notifyStart")
        private String notifyStart;

        /** 通知结束时段 */
        @JsonProperty("notifyEnd")
        private String notifyEnd;

        /**
         * 本参数表示告警规则启用状态。取值范围：<br>
         * 0：启用。<br>
         * 1：停用。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("status")
        private Integer status;

        /** webhook消息推送url */
        @JsonProperty("webhookUrl")
        private List<String> webhookUrl;

        /** 资源分组ID */
        @JsonProperty("resGroupID")
        private String resGroupID;

        /** 创建时间 */
        @JsonProperty("createTime")
        private Integer createTime;

        /** 更新时间 */
        @JsonProperty("updateTime")
        private Integer updateTime;

        /** 项目ID */
        @JsonProperty("projectID")
        private String projectID;

        /** 具体匹配资源 */
        @JsonProperty("resources")
        private List<DescribealarmRuleVdaReturnObjAlarmRuleResourcesResponse> resources;

        /** 触发规则的条件 */
        @JsonProperty("condition")
        private List<DescribealarmRuleVdaReturnObjAlarmRuleConditionResponse> condition;

        /** 自定义监控信息，仅支持部分资源池 */
        @JsonProperty("dimensions")
        private List<DescribealarmRuleVdaReturnObjAlarmRuleDimensionsResponse> dimensions;

        /**
         * 本参数表示告警策略触发类型。取值范围：<br>
         * 0：或，任一条件触发。<br>
         * 1：全部条件满足触发。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("conditionType")
        private Integer conditionType;

        /**
         * 本参数表示告警规则是否告警。取值范围：<br>
         * 0：未触发告警。<br>
         * 1：触发告警。<br>
         * 2：无数据（仅部分资源池支持）。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("alarmStatus")
        private Integer alarmStatus;

        /**
         * 告警规则类型。取值范围：<br>
         * series：时序类监控。<br>
         * event：事件类。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("alarmType")
        private String alarmType;

        /** 告警规则来源 */
        @JsonProperty("project")
        private String project;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getAlarmRuleID() {
            return this.alarmRuleID;
        }

        public void setAlarmRuleID(String alarmRuleID) {
            this.alarmRuleID = alarmRuleID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public Integer getRepeatTimes() {
            return this.repeatTimes;
        }

        public void setRepeatTimes(Integer repeatTimes) {
            this.repeatTimes = repeatTimes;
        }

        public String getService() {
            return this.service;
        }

        public void setService(String service) {
            this.service = service;
        }

        public String getDimension() {
            return this.dimension;
        }

        public void setDimension(String dimension) {
            this.dimension = dimension;
        }

        public Integer getSilenceTime() {
            return this.silenceTime;
        }

        public void setSilenceTime(Integer silenceTime) {
            this.silenceTime = silenceTime;
        }

        public Integer getRecoverNotify() {
            return this.recoverNotify;
        }

        public void setRecoverNotify(Integer recoverNotify) {
            this.recoverNotify = recoverNotify;
        }

        public List<String> getNotifyType() {
            return this.notifyType;
        }

        public void setNotifyType(List<String> notifyType) {
            this.notifyType = notifyType;
        }

        public List<DescribealarmRuleVdaReturnObjAlarmRuleContactGroupListResponse>
                getContactGroupList() {
            return this.contactGroupList;
        }

        public void setContactGroupList(
                List<DescribealarmRuleVdaReturnObjAlarmRuleContactGroupListResponse>
                        contactGroupList) {
            this.contactGroupList = contactGroupList;
        }

        public List<Integer> getNotifyWeekdays() {
            return this.notifyWeekdays;
        }

        public void setNotifyWeekdays(List<Integer> notifyWeekdays) {
            this.notifyWeekdays = notifyWeekdays;
        }

        public String getNotifyStart() {
            return this.notifyStart;
        }

        public void setNotifyStart(String notifyStart) {
            this.notifyStart = notifyStart;
        }

        public String getNotifyEnd() {
            return this.notifyEnd;
        }

        public void setNotifyEnd(String notifyEnd) {
            this.notifyEnd = notifyEnd;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public List<String> getWebhookUrl() {
            return this.webhookUrl;
        }

        public void setWebhookUrl(List<String> webhookUrl) {
            this.webhookUrl = webhookUrl;
        }

        public String getResGroupID() {
            return this.resGroupID;
        }

        public void setResGroupID(String resGroupID) {
            this.resGroupID = resGroupID;
        }

        public Integer getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(Integer createTime) {
            this.createTime = createTime;
        }

        public Integer getUpdateTime() {
            return this.updateTime;
        }

        public void setUpdateTime(Integer updateTime) {
            this.updateTime = updateTime;
        }

        public String getProjectID() {
            return this.projectID;
        }

        public void setProjectID(String projectID) {
            this.projectID = projectID;
        }

        public List<DescribealarmRuleVdaReturnObjAlarmRuleResourcesResponse> getResources() {
            return this.resources;
        }

        public void setResources(
                List<DescribealarmRuleVdaReturnObjAlarmRuleResourcesResponse> resources) {
            this.resources = resources;
        }

        public List<DescribealarmRuleVdaReturnObjAlarmRuleConditionResponse> getCondition() {
            return this.condition;
        }

        public void setCondition(
                List<DescribealarmRuleVdaReturnObjAlarmRuleConditionResponse> condition) {
            this.condition = condition;
        }

        public List<DescribealarmRuleVdaReturnObjAlarmRuleDimensionsResponse> getDimensions() {
            return this.dimensions;
        }

        public void setDimensions(
                List<DescribealarmRuleVdaReturnObjAlarmRuleDimensionsResponse> dimensions) {
            this.dimensions = dimensions;
        }

        public Integer getConditionType() {
            return this.conditionType;
        }

        public void setConditionType(Integer conditionType) {
            this.conditionType = conditionType;
        }

        public Integer getAlarmStatus() {
            return this.alarmStatus;
        }

        public void setAlarmStatus(Integer alarmStatus) {
            this.alarmStatus = alarmStatus;
        }

        public String getAlarmType() {
            return this.alarmType;
        }

        public void setAlarmType(String alarmType) {
            this.alarmType = alarmType;
        }

        public String getProject() {
            return this.project;
        }

        public void setProject(String project) {
            this.project = project;
        }
    }

    public static class DescribealarmRuleVdaReturnObjAlarmRuleContactGroupListResponse {
        /** 联系组ID */
        @JsonProperty("groupID")
        private String groupID;

        /** 联系组名称 */
        @JsonProperty("name")
        private String name;

        public String getGroupID() {
            return this.groupID;
        }

        public void setGroupID(String groupID) {
            this.groupID = groupID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static class DescribealarmRuleVdaReturnObjAlarmRuleResourcesResponse {
        /** 资源信息 */
        @JsonProperty("resource")
        private List<DescribealarmRuleVdaReturnObjAlarmRuleResourcesResourceResponse> resource;

        public List<DescribealarmRuleVdaReturnObjAlarmRuleResourcesResourceResponse> getResource() {
            return this.resource;
        }

        public void setResource(
                List<DescribealarmRuleVdaReturnObjAlarmRuleResourcesResourceResponse> resource) {
            this.resource = resource;
        }
    }

    public static class DescribealarmRuleVdaReturnObjAlarmRuleConditionResponse {
        /** 持续次数，当规则执行结果持续多久符合条件时报警（防抖），默认2次 */
        @JsonProperty("evaluationCount")
        private Integer evaluationCount;

        /** 监控指标 */
        @JsonProperty("metric")
        private String metric;

        /** 监控指标中文名 */
        @JsonProperty("metricCnName")
        private String metricCnName;

        /**
         * 本参数表示告警采用算法。取值范围：<br>
         * last：原始值算法。<br>
         * avg：平均值算法。<br>
         * max：最大值算法。<br>
         * min：最小值算法。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("fun")
        private String fun;

        /**
         * 本参数表示比较符。取值范围：<br>
         * eq：等于。<br>
         * gt：大于。<br>
         * ge：大于等于。<br>
         * lt：小于。<br>
         * le：小于等于。<br>
         * rg：环比上升。<br>
         * cf：环比下降。<br>
         * rc：环比变化。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("operator")
        private String operator;

        /** 告警阈值，可以是整数、小数或百分数格式字符串 */
        @JsonProperty("value")
        private String value;

        /**
         * 本参数表示算法统计周期。默认值5m。<br>
         * 参数fun为last时不可传。<br>
         * 参数fun为avg、max、min均需填此参数。<br>
         * 本参数格式为“数字+单位”。单位取值范围：<br>
         * m：分钟。<br>
         * h：小时。<br>
         * d：天。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("period")
        private String period;

        /** 监控指标单位 */
        @JsonProperty("unit")
        private String unit;

        public Integer getEvaluationCount() {
            return this.evaluationCount;
        }

        public void setEvaluationCount(Integer evaluationCount) {
            this.evaluationCount = evaluationCount;
        }

        public String getMetric() {
            return this.metric;
        }

        public void setMetric(String metric) {
            this.metric = metric;
        }

        public String getMetricCnName() {
            return this.metricCnName;
        }

        public void setMetricCnName(String metricCnName) {
            this.metricCnName = metricCnName;
        }

        public String getFun() {
            return this.fun;
        }

        public void setFun(String fun) {
            this.fun = fun;
        }

        public String getOperator() {
            return this.operator;
        }

        public void setOperator(String operator) {
            this.operator = operator;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getPeriod() {
            return this.period;
        }

        public void setPeriod(String period) {
            this.period = period;
        }

        public String getUnit() {
            return this.unit;
        }

        public void setUnit(String unit) {
            this.unit = unit;
        }
    }

    public static class DescribealarmRuleVdaReturnObjAlarmRuleDimensionsResponse {
        /** 自定义监控资源实例标签键 */
        @JsonProperty("name")
        private String name;

        /** 自定义监控资源实例标签值 */
        @JsonProperty("value")
        private List<String> value;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<String> getValue() {
            return this.value;
        }

        public void setValue(List<String> value) {
            this.value = value;
        }
    }

    public static class DescribealarmRuleVdaReturnObjAlarmRuleResourcesResourceResponse {
        /** 资源实例标签键 */
        @JsonProperty("name")
        private String name;

        /** 资源实例标签值 */
        @JsonProperty("value")
        private String value;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}
