package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 此接口用于禁用一个产品的一键报警规则。 */
public class MonitorDisableAlertOnekeyServiceViewApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorDisableAlertOnekeyServiceViewApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v4/monitor/alert-onekey/disable-service",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public DisableAlertOnekeyServiceViewResponse send(
            Credential credential, DisableAlertOnekeyServiceViewRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(DisableAlertOnekeyServiceViewResponse.class);
    }

    public static class DisableAlertOnekeyServiceViewRequest {
        /** 资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /**
         * 本参数表示产品名称。取值范围：<br>
         * ecs：云主机。<br>
         * evs：云硬盘。<br>
         * ...<br>
         * 详见“[一键报警：产品列表]”接口返回。
         */
        @JsonProperty("service")
        private String service;

        /**
         * 本参数表示告警类型。 取值范围：<br>
         * series：时序指标。<br>
         * event：事件。 <br>
         * 根据以上范围取值。
         */
        @JsonProperty("alarmType")
        private String alarmType;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getService() {
            return this.service;
        }

        public void setService(String service) {
            this.service = service;
        }

        public String getAlarmType() {
            return this.alarmType;
        }

        public void setAlarmType(String alarmType) {
            this.alarmType = alarmType;
        }
    }

    public static class DisableAlertOnekeyServiceViewResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，一般为中文描述 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 返回参数 */
        @JsonProperty("returnObj")
        private DisableAlertOnekeyServiceViewReturnObjResponse returnObj;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public DisableAlertOnekeyServiceViewReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(DisableAlertOnekeyServiceViewReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class DisableAlertOnekeyServiceViewReturnObjResponse {
        /** 是否成功 */
        @JsonProperty("success")
        private Boolean success;

        public Boolean getSuccess() {
            return this.success;
        }

        public void setSuccess(Boolean success) {
            this.success = success;
        }
    }
}
