package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 调用此接口可下载数据导出任务decsv文件。 */
public class MonitorDownloadDataExportTaskApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorDownloadDataExportTaskApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v4/monitor/task-center/download",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public DownloadDataExportTaskResponse send(
            Credential credential, DownloadDataExportTaskRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(DownloadDataExportTaskResponse.class);
    }

    public static class DownloadDataExportTaskRequest {
        /** 资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 任务ID */
        @JsonProperty("taskID")
        private String taskID;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getTaskID() {
            return this.taskID;
        }

        public void setTaskID(String taskID) {
            this.taskID = taskID;
        }
    }

    public static class DownloadDataExportTaskResponse {}
}
