package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询监控看板列表，仅返回基础信息，不返回视图信息。 */
public class MonitorListMonitorBoardApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorListMonitorBoardApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v4/monitor/monitor-board/list", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ListMonitorBoardResponse send(Credential credential, ListMonitorBoardRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionID != null) {
            ctReq.addParam("regionID", request.regionID);
            request.regionID = null;
        }
        if (request.boardType != null) {
            ctReq.addParam("boardType", request.boardType);
            request.boardType = null;
        }
        if (request.name != null) {
            ctReq.addParam("name", request.name);
            request.name = null;
        }
        if (request.service != null) {
            ctReq.addParam("service", request.service);
            request.service = null;
        }
        if (request.dimension != null) {
            ctReq.addParam("dimension", request.dimension);
            request.dimension = null;
        }
        if (request.pageNo != null) {
            ctReq.addParam("pageNo", String.valueOf(request.pageNo));
            request.pageNo = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ListMonitorBoardResponse.class);
    }

    public static class ListMonitorBoardRequest {
        /** 资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /**
         * 看板类型。默认all。取值范围：<br>
         * all：查询所有。<br>
         * system：系统默认看板。<br>
         * custom：自定义看板。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("boardType")
        private String boardType;

        /** 名称模糊搜索 */
        @JsonProperty("name")
        private String name;

        /**
         * 视图中包含指定云监控服务的看板，仅当boardType为system时有效。取值范围参见[监控看板：查询系统看板支持服务维度](https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=22&api=15782&data=90&isNormal=1&vid=84)
         */
        @JsonProperty("service")
        private String service;

        /**
         * 视图中包含指定云监控维度的看板，仅当boardType为system时有效。取值范围参见[监控看板：查询系统看板支持服务维度](https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=22&api=15782&data=90&isNormal=1&vid=84)
         */
        @JsonProperty("dimension")
        private String dimension;

        /** 页码，默认为1 */
        @JsonProperty("pageNo")
        private Integer pageNo;

        /** 页大小，默认为10 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getBoardType() {
            return this.boardType;
        }

        public void setBoardType(String boardType) {
            this.boardType = boardType;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getService() {
            return this.service;
        }

        public void setService(String service) {
            this.service = service;
        }

        public String getDimension() {
            return this.dimension;
        }

        public void setDimension(String dimension) {
            this.dimension = dimension;
        }

        public Integer getPageNo() {
            return this.pageNo;
        }

        public void setPageNo(Integer pageNo) {
            this.pageNo = pageNo;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }
    }

    public static class ListMonitorBoardResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，适配中英文 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 失败时的错误描述，适配中英文 */
        @JsonProperty("description")
        private String description;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private ListMonitorBoardReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public ListMonitorBoardReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(ListMonitorBoardReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class ListMonitorBoardReturnObjResponse {
        /** 监控看板列表 */
        @JsonProperty("boardList")
        private List<ListMonitorBoardReturnObjBoardListResponse> boardList;

        /** 当前页记录数 */
        @JsonProperty("currentCount")
        private Integer currentCount;

        /** 总记录数 */
        @JsonProperty("totalCount")
        private Integer totalCount;

        /** 总页数 */
        @JsonProperty("totalPage")
        private Integer totalPage;

        /** 监控看板配额剩余数量 */
        @JsonProperty("boardQuota")
        private Integer boardQuota;

        public List<ListMonitorBoardReturnObjBoardListResponse> getBoardList() {
            return this.boardList;
        }

        public void setBoardList(List<ListMonitorBoardReturnObjBoardListResponse> boardList) {
            this.boardList = boardList;
        }

        public Integer getCurrentCount() {
            return this.currentCount;
        }

        public void setCurrentCount(Integer currentCount) {
            this.currentCount = currentCount;
        }

        public Integer getTotalCount() {
            return this.totalCount;
        }

        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        public Integer getTotalPage() {
            return this.totalPage;
        }

        public void setTotalPage(Integer totalPage) {
            this.totalPage = totalPage;
        }

        public Integer getBoardQuota() {
            return this.boardQuota;
        }

        public void setBoardQuota(Integer boardQuota) {
            this.boardQuota = boardQuota;
        }
    }

    public static class ListMonitorBoardReturnObjBoardListResponse {
        /** 监控看板ID */
        @JsonProperty("boardID")
        private String boardID;

        /**
         * 看板类型。取值范围：<br>
         * system：系统默认看板。<br>
         * custom：自定义看板。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("type")
        private String type;

        /** 监控看板名称 */
        @JsonProperty("name")
        private String name;

        /** 创建时间，时间戳，精确到秒 */
        @JsonProperty("createTime")
        private Integer createTime;

        /** 最近更新时间, 时间戳，精确到秒 */
        @JsonProperty("updateTime")
        private Integer updateTime;

        public String getBoardID() {
            return this.boardID;
        }

        public void setBoardID(String boardID) {
            this.boardID = boardID;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Integer getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(Integer createTime) {
            this.createTime = createTime;
        }

        public Integer getUpdateTime() {
            return this.updateTime;
        }

        public void setUpdateTime(Integer updateTime) {
            this.updateTime = updateTime;
        }
    }
}
