package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 此接口用于获取单个产品一键报警规则配置信息。 */
public class MonitorQueryAlertOnekeyAlertConfigViewApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorQueryAlertOnekeyAlertConfigViewApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v4/monitor/alert-onekey/describe-alert-config",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public QueryAlertOnekeyAlertConfigViewResponse send(
            Credential credential, QueryAlertOnekeyAlertConfigViewRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionID != null) {
            ctReq.addParam("regionID", request.regionID);
            request.regionID = null;
        }
        if (request.service != null) {
            ctReq.addParam("service", request.service);
            request.service = null;
        }
        if (request.alarmType != null) {
            ctReq.addParam("alarmType", request.alarmType);
            request.alarmType = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(QueryAlertOnekeyAlertConfigViewResponse.class);
    }

    public static class QueryAlertOnekeyAlertConfigViewRequest {
        /** ctyun资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /**
         * 本参数表示产品名称。取值范围：<br>
         * ecs：云主机。<br>
         * evs：云硬盘。<br>
         * ...<br>
         * 详见“[一键报警：产品列表]”接口返回。
         */
        @JsonProperty("service")
        private String service;

        /**
         * 本参数表示告警类型。 取值范围：<br>
         * series：时序指标。<br>
         * event：事件。 <br>
         * 根据以上范围取值。
         */
        @JsonProperty("alarmType")
        private String alarmType;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getService() {
            return this.service;
        }

        public void setService(String service) {
            this.service = service;
        }

        public String getAlarmType() {
            return this.alarmType;
        }

        public void setAlarmType(String alarmType) {
            this.alarmType = alarmType;
        }
    }

    public static class QueryAlertOnekeyAlertConfigViewResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，一般为中文描述 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 返回参数 */
        @JsonProperty("returnObj")
        private QueryAlertOnekeyAlertConfigViewReturnObjResponse returnObj;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public QueryAlertOnekeyAlertConfigViewReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(QueryAlertOnekeyAlertConfigViewReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class QueryAlertOnekeyAlertConfigViewReturnObjResponse {
        /** 初始化规则列表 */
        @JsonProperty("alertConfigList")
        private List<QueryAlertOnekeyAlertConfigViewReturnObjAlertConfigListResponse>
                alertConfigList;

        public List<QueryAlertOnekeyAlertConfigViewReturnObjAlertConfigListResponse>
                getAlertConfigList() {
            return this.alertConfigList;
        }

        public void setAlertConfigList(
                List<QueryAlertOnekeyAlertConfigViewReturnObjAlertConfigListResponse>
                        alertConfigList) {
            this.alertConfigList = alertConfigList;
        }
    }

    public static class QueryAlertOnekeyAlertConfigViewReturnObjAlertConfigListResponse {
        /** 规则ID */
        @JsonProperty("alarmRuleID")
        private String alarmRuleID;

        /** 规则名称 */
        @JsonProperty("name")
        private String name;

        /**
         * 服务。取值范围：<br>
         * ecs：云主机。<br>
         * evs：云硬盘。<br>
         * ...<br>
         * 详见“[一键报警：产品列表]”接口返回。
         */
        @JsonProperty("service")
        private String service;

        /**
         * 维度。取值范围：<br>
         * ecs：云主机。<br>
         * disk：磁盘。<br>
         * pms：物理机。<br>
         * ...<br>
         * 详见“[告警规则：获取告警服务维度关系](https://www.ctyun.cn/document/10032263/10040009)”接口返回。
         */
        @JsonProperty("dimension")
        private String dimension;

        /** 连续出现次数 */
        @JsonProperty("evaluationCount")
        private Integer evaluationCount;

        /** 指标名 */
        @JsonProperty("metric")
        private String metric;

        /** 重复告警通知次数，默认为0 */
        @JsonProperty("repeatTimes")
        private Integer repeatTimes;

        /** 告警接收策略静默时间，多久重复通知一次，单位为秒 */
        @JsonProperty("silenceTime")
        private Integer silenceTime;

        /**
         * 恢复是否通知。值范围：<br>
         * 0：否。<br>
         * 1：是。
         */
        @JsonProperty("recoverNotify")
        private Integer recoverNotify;

        /**
         * 告警接收策略。值范围：<br>
         * email：邮件告警。<br>
         * sms：短信告警。
         */
        @JsonProperty("notifyType")
        private List<String> notifyType;

        /** 告警联系人组 */
        @JsonProperty("contactGroupList")
        private List<String> contactGroupList;

        /**
         * 通知周期。值范围：<br>
         * 0：周日。<br>
         * 1：周一。<br>
         * 2：周二。<br>
         * 3：周三。<br>
         * 4：周四。<br>
         * 5：周五。<br>
         * 6：周六。
         */
        @JsonProperty("notifyWeekdays")
        private List<Integer> notifyWeekdays;

        /** 通知起始时段 */
        @JsonProperty("notifyStart")
        private String notifyStart;

        /** 通知结束时段 */
        @JsonProperty("notifyEnd")
        private String notifyEnd;

        /** 告警状态变更webhook推送地址 */
        @JsonProperty("webhookUrl")
        private String webhookUrl;

        /**
         * 告警规则启用状态。值范围：<br>
         * 0：启用。<br>
         * 1：停用。
         */
        @JsonProperty("status")
        private Integer status;

        /** 创建时间 */
        @JsonProperty("createTime")
        private Integer createTime;

        /** 更新时间 */
        @JsonProperty("updateTime")
        private Integer updateTime;

        /**
         * 注意：一键报警规则的告警类型（alarmType）为事件类型（event）时，没有此返回参数。<br>
         * 此参数表示比较符。范围：<br>
         * eq：等于。<br>
         * gt：大于。<br>
         * ge：大于等于。<br>
         * lt：小于。<br>
         * le：小于等于。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("operator")
        private String operator;

        /**
         * 注意：一键报警规则的告警类型（alarmType）为事件类型（event）时，没有此返回参数。 <br>
         * 此参数表示告警阈值，可以是整数、小数或百分数格式字符串
         */
        @JsonProperty("value")
        private String value;

        public String getAlarmRuleID() {
            return this.alarmRuleID;
        }

        public void setAlarmRuleID(String alarmRuleID) {
            this.alarmRuleID = alarmRuleID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getService() {
            return this.service;
        }

        public void setService(String service) {
            this.service = service;
        }

        public String getDimension() {
            return this.dimension;
        }

        public void setDimension(String dimension) {
            this.dimension = dimension;
        }

        public Integer getEvaluationCount() {
            return this.evaluationCount;
        }

        public void setEvaluationCount(Integer evaluationCount) {
            this.evaluationCount = evaluationCount;
        }

        public String getMetric() {
            return this.metric;
        }

        public void setMetric(String metric) {
            this.metric = metric;
        }

        public Integer getRepeatTimes() {
            return this.repeatTimes;
        }

        public void setRepeatTimes(Integer repeatTimes) {
            this.repeatTimes = repeatTimes;
        }

        public Integer getSilenceTime() {
            return this.silenceTime;
        }

        public void setSilenceTime(Integer silenceTime) {
            this.silenceTime = silenceTime;
        }

        public Integer getRecoverNotify() {
            return this.recoverNotify;
        }

        public void setRecoverNotify(Integer recoverNotify) {
            this.recoverNotify = recoverNotify;
        }

        public List<String> getNotifyType() {
            return this.notifyType;
        }

        public void setNotifyType(List<String> notifyType) {
            this.notifyType = notifyType;
        }

        public List<String> getContactGroupList() {
            return this.contactGroupList;
        }

        public void setContactGroupList(List<String> contactGroupList) {
            this.contactGroupList = contactGroupList;
        }

        public List<Integer> getNotifyWeekdays() {
            return this.notifyWeekdays;
        }

        public void setNotifyWeekdays(List<Integer> notifyWeekdays) {
            this.notifyWeekdays = notifyWeekdays;
        }

        public String getNotifyStart() {
            return this.notifyStart;
        }

        public void setNotifyStart(String notifyStart) {
            this.notifyStart = notifyStart;
        }

        public String getNotifyEnd() {
            return this.notifyEnd;
        }

        public void setNotifyEnd(String notifyEnd) {
            this.notifyEnd = notifyEnd;
        }

        public String getWebhookUrl() {
            return this.webhookUrl;
        }

        public void setWebhookUrl(String webhookUrl) {
            this.webhookUrl = webhookUrl;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public Integer getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(Integer createTime) {
            this.createTime = createTime;
        }

        public Integer getUpdateTime() {
            return this.updateTime;
        }

        public void setUpdateTime(Integer updateTime) {
            this.updateTime = updateTime;
        }

        public String getOperator() {
            return this.operator;
        }

        public void setOperator(String operator) {
            this.operator = operator;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}
