package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 调用此接口可查询用户在指定资源池云主机监控中cpu使用率Top-N。 */
public class MonitorQueryCpuTopApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorQueryCpuTopApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "POST", "/v4/monitor/query-cpu-top", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public QueryCpuTopResponse send(Credential credential, QueryCpuTopRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(QueryCpuTopResponse.class);
    }

    public static class QueryCpuTopRequest {
        /** 资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /**
         * 选取TOP值的数量，不传默认为3，当传入值或默认值超过用户实际拥有的资源数量，以用户的实际资源数量为准。 建议传值数量不大于10，否则会影响接口响应时间较长。
         * 若要查询更多主机监控，请参考[实时监控数据：查询v4.2](https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=22&api=14172&data=90&isNormal=1&vid=84)。
         */
        @JsonProperty("number")
        private Integer number;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public Integer getNumber() {
            return this.number;
        }

        public void setNumber(Integer number) {
            this.number = number;
        }
    }

    public static class QueryCpuTopResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，一般为中文描述 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private QueryCpuTopReturnObjResponse returnObj;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public QueryCpuTopReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(QueryCpuTopReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class QueryCpuTopReturnObjResponse {
        /** cpu利用率列表 */
        @JsonProperty("cpuList")
        private List<QueryCpuTopReturnObjCpuListResponse> cpuList;

        public List<QueryCpuTopReturnObjCpuListResponse> getCpuList() {
            return this.cpuList;
        }

        public void setCpuList(List<QueryCpuTopReturnObjCpuListResponse> cpuList) {
            this.cpuList = cpuList;
        }
    }

    public static class QueryCpuTopReturnObjCpuListResponse {
        /** 设备ID */
        @JsonProperty("deviceID")
        private String deviceID;

        /** 设备名字 */
        @JsonProperty("name")
        private String name;

        /** cpu利用率的值 */
        @JsonProperty("value")
        private String value;

        public String getDeviceID() {
            return this.deviceID;
        }

        public void setDeviceID(String deviceID) {
            this.deviceID = deviceID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}
