package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 根据筛选项查询自定义事件告警规则列表。 */
public class MonitorQueryCustomEventAlarmRulesApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorQueryCustomEventAlarmRulesApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v4/monitor/query-custom-event-alarm-rules",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public QueryCustomEventAlarmRulesResponse send(
            Credential credential, QueryCustomEventAlarmRulesRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionID != null) {
            ctReq.addParam("regionID", request.regionID);
            request.regionID = null;
        }
        if (request.status != null) {
            ctReq.addParam("status", String.valueOf(request.status));
            request.status = null;
        }
        if (request.alarmStatus != null) {
            ctReq.addParam("alarmStatus", String.valueOf(request.alarmStatus));
            request.alarmStatus = null;
        }
        if (request.name != null) {
            ctReq.addParam("name", request.name);
            request.name = null;
        }
        if (request.sort != null) {
            ctReq.addParam("sort", request.sort);
            request.sort = null;
        }
        if (request.pageNo != null) {
            ctReq.addParam("pageNo", String.valueOf(request.pageNo));
            request.pageNo = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(QueryCustomEventAlarmRulesResponse.class);
    }

    public static class QueryCustomEventAlarmRulesRequest {
        /** ctyun资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /**
         * 本参数表示告警规则启用状态。取值范围：<br>
         * 0：启用。<br>
         * 1：停用。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("status")
        private Integer status;

        /**
         * 本参数表示告警规则告警状态。取值范围：<br>
         * 0：正常。<br>
         * 1：正在告警。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("alarmStatus")
        private Integer alarmStatus;

        /** 规则名称 */
        @JsonProperty("name")
        private String name;

        /**
         * 本参数表示排序条件，-表示降序。支持的排序字段：<br>
         * updateTime：更新时间。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("sort")
        private String sort;

        /** 页码，默认为1 */
        @JsonProperty("pageNo")
        private Integer pageNo;

        /** 页大小，默认为20 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public Integer getAlarmStatus() {
            return this.alarmStatus;
        }

        public void setAlarmStatus(Integer alarmStatus) {
            this.alarmStatus = alarmStatus;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getSort() {
            return this.sort;
        }

        public void setSort(String sort) {
            this.sort = sort;
        }

        public Integer getPageNo() {
            return this.pageNo;
        }

        public void setPageNo(Integer pageNo) {
            this.pageNo = pageNo;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }
    }

    public static class QueryCustomEventAlarmRulesResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，一般为中文描述 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private QueryCustomEventAlarmRulesReturnObjResponse returnObj;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public QueryCustomEventAlarmRulesReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(QueryCustomEventAlarmRulesReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class QueryCustomEventAlarmRulesReturnObjResponse {
        /** 告警规则 */
        @JsonProperty("alarmRules")
        private List<QueryCustomEventAlarmRulesReturnObjAlarmRulesResponse> alarmRules;

        /** 总记录数 */
        @JsonProperty("totalCount")
        private Integer totalCount;

        /** 当前页记录数 */
        @JsonProperty("currentCount")
        private Integer currentCount;

        /** 总页数 */
        @JsonProperty("totalPage")
        private Integer totalPage;

        public List<QueryCustomEventAlarmRulesReturnObjAlarmRulesResponse> getAlarmRules() {
            return this.alarmRules;
        }

        public void setAlarmRules(
                List<QueryCustomEventAlarmRulesReturnObjAlarmRulesResponse> alarmRules) {
            this.alarmRules = alarmRules;
        }

        public Integer getTotalCount() {
            return this.totalCount;
        }

        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        public Integer getCurrentCount() {
            return this.currentCount;
        }

        public void setCurrentCount(Integer currentCount) {
            this.currentCount = currentCount;
        }

        public Integer getTotalPage() {
            return this.totalPage;
        }

        public void setTotalPage(Integer totalPage) {
            this.totalPage = totalPage;
        }
    }

    public static class QueryCustomEventAlarmRulesReturnObjAlarmRulesResponse {
        /** 告警规则ID */
        @JsonProperty("alarmRuleID")
        private String alarmRuleID;

        /** ctyun资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 规则名 */
        @JsonProperty("name")
        private String name;

        /** 描述 */
        @JsonProperty("desc")
        private String desc;

        /** 重复告警通知次数，默认为0 */
        @JsonProperty("repeatTimes")
        private Integer repeatTimes;

        /** 告警接收策略静默时间，多久重复通知一次，单位为秒 */
        @JsonProperty("silenceTime")
        private Integer silenceTime;

        /**
         * 本参数表示恢复是否通知。默认值0。取值范围：<br>
         * 0：否。<br>
         * 1：是。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("recoverNotify")
        private Integer recoverNotify;

        /**
         * 本参数表示告警接收策略。取值范围：<br>
         * email：邮件告警。<br>
         * sms：短信告警。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("notifyType")
        private List<String> notifyType;

        /** 告警联系人组 */
        @JsonProperty("contactGroupList")
        private List<String> contactGroupList;

        /**
         * 本参数表示通知周期。默认值[0,1,2,3,4,5,6]。取值范围：<br>
         * 0：周日。<br>
         * 1：周一。<br>
         * 2：周二。<br>
         * 3：周三。<br>
         * 4：周四。<br>
         * 5：周五。<br>
         * 6：周六。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("notifyWeekdays")
        private List<Integer> notifyWeekdays;

        /** 通知起始时段，默认为00:00:00 */
        @JsonProperty("notifyStart")
        private String notifyStart;

        /** 通知结束时段，默认为23:59:59 */
        @JsonProperty("notifyEnd")
        private String notifyEnd;

        /** 告警状态变更webhook推送地址 */
        @JsonProperty("webhookUrl")
        private String webhookUrl;

        /** 自定义监控指标 */
        @JsonProperty("customEventID")
        private String customEventID;

        /** 出现次数，告警阈值，整数格式字符串 */
        @JsonProperty("value")
        private String value;

        /**
         * 本参数表示算法统计周期。默认值5m。<br>
         * 本参数格式为“数字+单位”。最大周期为24小时。单位取值范围：<br>
         * m：分钟。<br>
         * h：小时。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("period")
        private String period;

        /** 创建时间 */
        @JsonProperty("createTime")
        private Integer createTime;

        /** 更新时间 */
        @JsonProperty("updateTime")
        private Integer updateTime;

        public String getAlarmRuleID() {
            return this.alarmRuleID;
        }

        public void setAlarmRuleID(String alarmRuleID) {
            this.alarmRuleID = alarmRuleID;
        }

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public Integer getRepeatTimes() {
            return this.repeatTimes;
        }

        public void setRepeatTimes(Integer repeatTimes) {
            this.repeatTimes = repeatTimes;
        }

        public Integer getSilenceTime() {
            return this.silenceTime;
        }

        public void setSilenceTime(Integer silenceTime) {
            this.silenceTime = silenceTime;
        }

        public Integer getRecoverNotify() {
            return this.recoverNotify;
        }

        public void setRecoverNotify(Integer recoverNotify) {
            this.recoverNotify = recoverNotify;
        }

        public List<String> getNotifyType() {
            return this.notifyType;
        }

        public void setNotifyType(List<String> notifyType) {
            this.notifyType = notifyType;
        }

        public List<String> getContactGroupList() {
            return this.contactGroupList;
        }

        public void setContactGroupList(List<String> contactGroupList) {
            this.contactGroupList = contactGroupList;
        }

        public List<Integer> getNotifyWeekdays() {
            return this.notifyWeekdays;
        }

        public void setNotifyWeekdays(List<Integer> notifyWeekdays) {
            this.notifyWeekdays = notifyWeekdays;
        }

        public String getNotifyStart() {
            return this.notifyStart;
        }

        public void setNotifyStart(String notifyStart) {
            this.notifyStart = notifyStart;
        }

        public String getNotifyEnd() {
            return this.notifyEnd;
        }

        public void setNotifyEnd(String notifyEnd) {
            this.notifyEnd = notifyEnd;
        }

        public String getWebhookUrl() {
            return this.webhookUrl;
        }

        public void setWebhookUrl(String webhookUrl) {
            this.webhookUrl = webhookUrl;
        }

        public String getCustomEventID() {
            return this.customEventID;
        }

        public void setCustomEventID(String customEventID) {
            this.customEventID = customEventID;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getPeriod() {
            return this.period;
        }

        public void setPeriod(String period) {
            this.period = period;
        }

        public Integer getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(Integer createTime) {
            this.createTime = createTime;
        }

        public Integer getUpdateTime() {
            return this.updateTime;
        }

        public void setUpdateTime(Integer updateTime) {
            this.updateTime = updateTime;
        }
    }
}
