package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 调用此接口可查询自定义事件的监控详情。 */
public class MonitorQueryCustomEventDataApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorQueryCustomEventDataApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v4/monitor/query-custom-event-data",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public QueryCustomEventDataResponse send(
            Credential credential, QueryCustomEventDataRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(QueryCustomEventDataResponse.class);
    }

    public static class QueryCustomEventDataRequest {
        /** 资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 自定义事件ID列表 */
        @JsonProperty("customEventID")
        private List<String> customEventID;

        /** 查询起始时间戳，默认7天前 */
        @JsonProperty("startTime")
        private Integer startTime;

        /** 查询截止时间戳，默认当前时间 */
        @JsonProperty("endTime")
        private Integer endTime;

        /** 页码，不传默认为1 */
        @JsonProperty("pageNo")
        private Integer pageNo;

        /** 每页大小，不传默认为20 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public List<String> getCustomEventID() {
            return this.customEventID;
        }

        public void setCustomEventID(List<String> customEventID) {
            this.customEventID = customEventID;
        }

        public Integer getStartTime() {
            return this.startTime;
        }

        public void setStartTime(Integer startTime) {
            this.startTime = startTime;
        }

        public Integer getEndTime() {
            return this.endTime;
        }

        public void setEndTime(Integer endTime) {
            this.endTime = endTime;
        }

        public Integer getPageNo() {
            return this.pageNo;
        }

        public void setPageNo(Integer pageNo) {
            this.pageNo = pageNo;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }
    }

    public static class QueryCustomEventDataResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，一般为中文描述 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 返回参数，参考returnObj对象结构 */
        @JsonProperty("returnObj")
        private QueryCustomEventDataReturnObjResponse returnObj;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public QueryCustomEventDataReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(QueryCustomEventDataReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class QueryCustomEventDataReturnObjResponse {
        /** 自定义事件列表 */
        @JsonProperty("customEventMonitorList")
        private List<QueryCustomEventDataReturnObjCustomEventMonitorListResponse>
                customEventMonitorList;

        /** 总记录数 */
        @JsonProperty("totalCount")
        private Integer totalCount;

        /** 总页数 */
        @JsonProperty("totalPage")
        private Integer totalPage;

        /** 当前记录数 */
        @JsonProperty("currentCount")
        private Integer currentCount;

        public List<QueryCustomEventDataReturnObjCustomEventMonitorListResponse>
                getCustomEventMonitorList() {
            return this.customEventMonitorList;
        }

        public void setCustomEventMonitorList(
                List<QueryCustomEventDataReturnObjCustomEventMonitorListResponse>
                        customEventMonitorList) {
            this.customEventMonitorList = customEventMonitorList;
        }

        public Integer getTotalCount() {
            return this.totalCount;
        }

        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        public Integer getTotalPage() {
            return this.totalPage;
        }

        public void setTotalPage(Integer totalPage) {
            this.totalPage = totalPage;
        }

        public Integer getCurrentCount() {
            return this.currentCount;
        }

        public void setCurrentCount(Integer currentCount) {
            this.currentCount = currentCount;
        }
    }

    public static class QueryCustomEventDataReturnObjCustomEventMonitorListResponse {
        /** 资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 自定义事件ID */
        @JsonProperty("customEventID")
        private String customEventID;

        /** 事件名称 */
        @JsonProperty("name")
        private String name;

        /** 事件详情信息 */
        @JsonProperty("info")
        private String info;

        /** 事件发生时间戳，精确到毫秒 */
        @JsonProperty("clock")
        private Integer clock;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getCustomEventID() {
            return this.customEventID;
        }

        public void setCustomEventID(String customEventID) {
            this.customEventID = customEventID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getInfo() {
            return this.info;
        }

        public void setInfo(String info) {
            this.info = info;
        }

        public Integer getClock() {
            return this.clock;
        }

        public void setClock(Integer clock) {
            this.clock = clock;
        }
    }
}
