package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 调用此接口可查询自定义事件。 */
public class MonitorQueryCustomEventsApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorQueryCustomEventsApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v4/monitor/query-custom-events",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public QueryCustomEventsResponse send(Credential credential, QueryCustomEventsRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionID != null) {
            ctReq.addParam("regionID", request.regionID);
            request.regionID = null;
        }
        if (request.customEventID != null) {
            ctReq.addParam("customEventID", request.customEventID);
            request.customEventID = null;
        }
        if (request.name != null) {
            ctReq.addParam("name", request.name);
            request.name = null;
        }
        if (request.pageNo != null) {
            ctReq.addParam("pageNo", String.valueOf(request.pageNo));
            request.pageNo = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(QueryCustomEventsResponse.class);
    }

    public static class QueryCustomEventsRequest {
        /** 资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 自定义事件ID */
        @JsonProperty("customEventID")
        private String customEventID;

        /** 事件名称，支持模糊搜索 */
        @JsonProperty("name")
        private String name;

        /** 页码，不传默认为1 */
        @JsonProperty("pageNo")
        private Integer pageNo;

        /** 每页大小，不传默认为20 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getCustomEventID() {
            return this.customEventID;
        }

        public void setCustomEventID(String customEventID) {
            this.customEventID = customEventID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Integer getPageNo() {
            return this.pageNo;
        }

        public void setPageNo(Integer pageNo) {
            this.pageNo = pageNo;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }
    }

    public static class QueryCustomEventsResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，一般为中文描述 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 返回参数，参考returnObj对象结构 */
        @JsonProperty("returnObj")
        private QueryCustomEventsReturnObjResponse returnObj;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public QueryCustomEventsReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(QueryCustomEventsReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class QueryCustomEventsReturnObjResponse {
        /** 自定义事件列表 */
        @JsonProperty("customEventList")
        private List<QueryCustomEventsReturnObjCustomEventListResponse> customEventList;

        /** 总记录数 */
        @JsonProperty("totalCount")
        private Integer totalCount;

        /** 总页数 */
        @JsonProperty("totalPage")
        private Integer totalPage;

        /** 当前记录数 */
        @JsonProperty("currentCount")
        private Integer currentCount;

        public List<QueryCustomEventsReturnObjCustomEventListResponse> getCustomEventList() {
            return this.customEventList;
        }

        public void setCustomEventList(
                List<QueryCustomEventsReturnObjCustomEventListResponse> customEventList) {
            this.customEventList = customEventList;
        }

        public Integer getTotalCount() {
            return this.totalCount;
        }

        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        public Integer getTotalPage() {
            return this.totalPage;
        }

        public void setTotalPage(Integer totalPage) {
            this.totalPage = totalPage;
        }

        public Integer getCurrentCount() {
            return this.currentCount;
        }

        public void setCurrentCount(Integer currentCount) {
            this.currentCount = currentCount;
        }
    }

    public static class QueryCustomEventsReturnObjCustomEventListResponse {
        /** 资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 自定义事件ID */
        @JsonProperty("customEventID")
        private String customEventID;

        /** 事件名称 */
        @JsonProperty("name")
        private String name;

        /** 事件描述 */
        @JsonProperty("description")
        private String description;

        /** 创建时间戳，精确到毫秒 */
        @JsonProperty("createTime")
        private Integer createTime;

        /** 修改时间戳，精确到毫秒 */
        @JsonProperty("updateTime")
        private Integer updateTime;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getCustomEventID() {
            return this.customEventID;
        }

        public void setCustomEventID(String customEventID) {
            this.customEventID = customEventID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public Integer getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(Integer createTime) {
            this.createTime = createTime;
        }

        public Integer getUpdateTime() {
            return this.updateTime;
        }

        public void setUpdateTime(Integer updateTime) {
            this.updateTime = updateTime;
        }
    }
}
