package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询指定自定义监控的时序指标历史监控数据。 */
public class MonitorQueryCustomItemHistorymetricdataApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorQueryCustomItemHistorymetricdataApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v4/monitor/query-custom-item-historymetricdata",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public QueryCustomItemHistorymetricdataResponse send(
            Credential credential, QueryCustomItemHistorymetricdataRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(QueryCustomItemHistorymetricdataResponse.class);
    }

    public static class QueryCustomItemHistorymetricdataRequest {
        /** 资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 自定义监控项ID */
        @JsonProperty("customItemID")
        private String customItemID;

        /** 查询起始时间戳 */
        @JsonProperty("startTime")
        private String startTime;

        /** 查询结束时间戳 */
        @JsonProperty("endTime")
        private String endTime;

        /** 自定义监控项维度 */
        @JsonProperty("dimensions")
        private List<QueryCustomItemHistorymetricdataDimensionsRequest> dimensions;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getCustomItemID() {
            return this.customItemID;
        }

        public void setCustomItemID(String customItemID) {
            this.customItemID = customItemID;
        }

        public String getStartTime() {
            return this.startTime;
        }

        public void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        public String getEndTime() {
            return this.endTime;
        }

        public void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        public List<QueryCustomItemHistorymetricdataDimensionsRequest> getDimensions() {
            return this.dimensions;
        }

        public void setDimensions(
                List<QueryCustomItemHistorymetricdataDimensionsRequest> dimensions) {
            this.dimensions = dimensions;
        }
    }

    public static class QueryCustomItemHistorymetricdataDimensionsRequest {
        /** 维度名称 */
        @JsonProperty("name")
        private String name;

        /** 维度值 */
        @JsonProperty("value")
        private List<String> value;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<String> getValue() {
            return this.value;
        }

        public void setValue(List<String> value) {
            this.value = value;
        }
    }

    public static class QueryCustomItemHistorymetricdataResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，一般为中文描述 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private QueryCustomItemHistorymetricdataReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public QueryCustomItemHistorymetricdataReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(QueryCustomItemHistorymetricdataReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class QueryCustomItemHistorymetricdataReturnObjResponse {
        /** 返回数据结果 */
        @JsonProperty("result")
        private List<QueryCustomItemHistorymetricdataReturnObjResultResponse> result;

        public List<QueryCustomItemHistorymetricdataReturnObjResultResponse> getResult() {
            return this.result;
        }

        public void setResult(
                List<QueryCustomItemHistorymetricdataReturnObjResultResponse> result) {
            this.result = result;
        }
    }

    public static class QueryCustomItemHistorymetricdataReturnObjResultResponse {
        /** 所属资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 自定义监控项ID */
        @JsonProperty("customItemID")
        private String customItemID;

        /** 监控项值列表 */
        @JsonProperty("data")
        private List<QueryCustomItemHistorymetricdataReturnObjResultDataResponse> data;

        /** 自定义监控项维度 */
        @JsonProperty("dimensions")
        private List<QueryCustomItemHistorymetricdataReturnObjResultDimensionsResponse> dimensions;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getCustomItemID() {
            return this.customItemID;
        }

        public void setCustomItemID(String customItemID) {
            this.customItemID = customItemID;
        }

        public List<QueryCustomItemHistorymetricdataReturnObjResultDataResponse> getData() {
            return this.data;
        }

        public void setData(
                List<QueryCustomItemHistorymetricdataReturnObjResultDataResponse> data) {
            this.data = data;
        }

        public List<QueryCustomItemHistorymetricdataReturnObjResultDimensionsResponse>
                getDimensions() {
            return this.dimensions;
        }

        public void setDimensions(
                List<QueryCustomItemHistorymetricdataReturnObjResultDimensionsResponse>
                        dimensions) {
            this.dimensions = dimensions;
        }
    }

    public static class QueryCustomItemHistorymetricdataReturnObjResultDataResponse {
        /** 监控数据采样时间 */
        @JsonProperty("samplingTime")
        private Integer samplingTime;

        /** 监控项值，具体请参考对应监控项文档 */
        @JsonProperty("value")
        private String value;

        public Integer getSamplingTime() {
            return this.samplingTime;
        }

        public void setSamplingTime(Integer samplingTime) {
            this.samplingTime = samplingTime;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class QueryCustomItemHistorymetricdataReturnObjResultDimensionsResponse {
        /** 维度名称 */
        @JsonProperty("name")
        private String name;

        /** 维度值 */
        @JsonProperty("value")
        private String value;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}
