package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 根据指定时间段统计指定事件发生情况。 */
public class MonitorQueryEventCountDataApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorQueryEventCountDataApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "POST", "/v4/monitor/events/count-data", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public QueryEventCountDataResponse send(
            Credential credential, QueryEventCountDataRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(QueryEventCountDataResponse.class);
    }

    public static class QueryEventCountDataRequest {
        /** 资源池 ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 本参数表示事件指标，事件指标见查询事件接口返回。 */
        @JsonProperty("eventName")
        private String eventName;

        /** 服务，见事件监控：查询服务维度接口返回。 */
        @JsonProperty("service")
        private String service;

        /** 维度，见事件监控：查询服务维度接口返回。 */
        @JsonProperty("dimension")
        private String dimension;

        /** 查询起始时间戳 */
        @JsonProperty("startTime")
        private Integer startTime;

        /** 查询截止时间戳 */
        @JsonProperty("endTime")
        private Integer endTime;

        /** 统计周期 */
        @JsonProperty("period")
        private Integer period;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getEventName() {
            return this.eventName;
        }

        public void setEventName(String eventName) {
            this.eventName = eventName;
        }

        public String getService() {
            return this.service;
        }

        public void setService(String service) {
            this.service = service;
        }

        public String getDimension() {
            return this.dimension;
        }

        public void setDimension(String dimension) {
            this.dimension = dimension;
        }

        public Integer getStartTime() {
            return this.startTime;
        }

        public void setStartTime(Integer startTime) {
            this.startTime = startTime;
        }

        public Integer getEndTime() {
            return this.endTime;
        }

        public void setEndTime(Integer endTime) {
            this.endTime = endTime;
        }

        public Integer getPeriod() {
            return this.period;
        }

        public void setPeriod(Integer period) {
            this.period = period;
        }
    }

    public static class QueryEventCountDataResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，一般为中文描述 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private QueryEventCountDataReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public QueryEventCountDataReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(QueryEventCountDataReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class QueryEventCountDataReturnObjResponse {
        /** 事件统计信息 */
        @JsonProperty("data")
        private List<QueryEventCountDataReturnObjDataResponse> data;

        public List<QueryEventCountDataReturnObjDataResponse> getData() {
            return this.data;
        }

        public void setData(List<QueryEventCountDataReturnObjDataResponse> data) {
            this.data = data;
        }
    }

    public static class QueryEventCountDataReturnObjDataResponse {
        /** 事件统计数量 */
        @JsonProperty("value")
        private Integer value;

        /** 事件统计采样时间,秒级 */
        @JsonProperty("samplingTime")
        private Integer samplingTime;

        public Integer getValue() {
            return this.value;
        }

        public void setValue(Integer value) {
            this.value = value;
        }

        public Integer getSamplingTime() {
            return this.samplingTime;
        }

        public void setSamplingTime(Integer samplingTime) {
            this.samplingTime = samplingTime;
        }
    }
}
