package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 根据指定时间段查询事件发生情况。 */
public class MonitorQueryEventListApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorQueryEventListApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "POST", "/v4/monitor/events/query-list", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public QueryEventListResponse send(Credential credential, QueryEventListRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(QueryEventListResponse.class);
    }

    public static class QueryEventListRequest {
        /** 资源池 ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 本参数表示事件指标列表，事件指标见查询事件接口返回。不传，默认全部事件指标 */
        @JsonProperty("eventNameList")
        private List<String> eventNameList;

        /** 服务，见事件监控：查询服务维度接口返回。 */
        @JsonProperty("service")
        private String service;

        /** 维度，见事件监控：查询服务维度接口返回。 */
        @JsonProperty("dimension")
        private String dimension;

        /** 查询起始时间戳 */
        @JsonProperty("startTime")
        private Integer startTime;

        /** 查询截止时间戳 */
        @JsonProperty("endTime")
        private Integer endTime;

        /** 页码，默认为1 */
        @JsonProperty("pageNo")
        private Integer pageNo;

        /** 页大小，默认为20 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public List<String> getEventNameList() {
            return this.eventNameList;
        }

        public void setEventNameList(List<String> eventNameList) {
            this.eventNameList = eventNameList;
        }

        public String getService() {
            return this.service;
        }

        public void setService(String service) {
            this.service = service;
        }

        public String getDimension() {
            return this.dimension;
        }

        public void setDimension(String dimension) {
            this.dimension = dimension;
        }

        public Integer getStartTime() {
            return this.startTime;
        }

        public void setStartTime(Integer startTime) {
            this.startTime = startTime;
        }

        public Integer getEndTime() {
            return this.endTime;
        }

        public void setEndTime(Integer endTime) {
            this.endTime = endTime;
        }

        public Integer getPageNo() {
            return this.pageNo;
        }

        public void setPageNo(Integer pageNo) {
            this.pageNo = pageNo;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }
    }

    public static class QueryEventListResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，一般为中文描述 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private QueryEventListReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public QueryEventListReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(QueryEventListReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class QueryEventListReturnObjResponse {
        /** 获取对象数据条数 */
        @JsonProperty("totalCount")
        private Integer totalCount;

        /** 总页数 */
        @JsonProperty("totalPage")
        private Integer totalPage;

        /** 当前页记录数 */
        @JsonProperty("currentCount")
        private Integer currentCount;

        /** 事件列表 */
        @JsonProperty("eventList")
        private List<QueryEventListReturnObjEventListResponse> eventList;

        public Integer getTotalCount() {
            return this.totalCount;
        }

        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        public Integer getTotalPage() {
            return this.totalPage;
        }

        public void setTotalPage(Integer totalPage) {
            this.totalPage = totalPage;
        }

        public Integer getCurrentCount() {
            return this.currentCount;
        }

        public void setCurrentCount(Integer currentCount) {
            this.currentCount = currentCount;
        }

        public List<QueryEventListReturnObjEventListResponse> getEventList() {
            return this.eventList;
        }

        public void setEventList(List<QueryEventListReturnObjEventListResponse> eventList) {
            this.eventList = eventList;
        }
    }

    public static class QueryEventListReturnObjEventListResponse {
        /** 事件指标 */
        @JsonProperty("eventName")
        private String eventName;

        /** 事件中文描述 */
        @JsonProperty("description")
        private String description;

        /** 事件最后发生事件时间,秒级时间戳 */
        @JsonProperty("eventTime")
        private Integer eventTime;

        /** 事件数量 */
        @JsonProperty("eventCount")
        private Integer eventCount;

        public String getEventName() {
            return this.eventName;
        }

        public void setEventName(String eventName) {
            this.eventName = eventName;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public Integer getEventTime() {
            return this.eventTime;
        }

        public void setEventTime(Integer eventTime) {
            this.eventTime = eventTime;
        }

        public Integer getEventCount() {
            return this.eventCount;
        }

        public void setEventCount(Integer eventCount) {
            this.eventCount = eventCount;
        }
    }
}
