package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 调用此接口可查询巡检历史详情。 */
public class MonitorQueryHistoryDetailApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorQueryHistoryDetailApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v4/monitor/intelligent-inspection/query-history-detail",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public QueryHistoryDetailResponse send(Credential credential, QueryHistoryDetailRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(QueryHistoryDetailResponse.class);
    }

    public static class QueryHistoryDetailRequest {
        /** 巡检任务ID */
        @JsonProperty("taskID")
        private String taskID;

        /**
         * 本参数表示巡检项。取值范围：<br>
         * 1：云主机性能评估。<br>
         * 2：监控数据健康评估。<br>
         * 3：云主机闲置资源检查。<br>
         * 4：云主机磁盘使用预警评估<br>
         * 根据以上范围取值。
         */
        @JsonProperty("inspectionItem")
        private Integer inspectionItem;

        /** 页码，默认为1 */
        @JsonProperty("pageNo")
        private Integer pageNo;

        /** 页大小，默认为20 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        public String getTaskID() {
            return this.taskID;
        }

        public void setTaskID(String taskID) {
            this.taskID = taskID;
        }

        public Integer getInspectionItem() {
            return this.inspectionItem;
        }

        public void setInspectionItem(Integer inspectionItem) {
            this.inspectionItem = inspectionItem;
        }

        public Integer getPageNo() {
            return this.pageNo;
        }

        public void setPageNo(Integer pageNo) {
            this.pageNo = pageNo;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }
    }

    public static class QueryHistoryDetailResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，一般为中文描述 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 返回参数，参考returnObj对象结构 */
        @JsonProperty("returnObj")
        private QueryHistoryDetailReturnObjResponse returnObj;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public QueryHistoryDetailReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(QueryHistoryDetailReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class QueryHistoryDetailReturnObjResponse {
        /** 异常详情列表 */
        @JsonProperty("anomalyDetail")
        private List<QueryHistoryDetailReturnObjAnomalyDetailResponse> anomalyDetail;

        /** 获取对象数据条数 */
        @JsonProperty("totalCount")
        private Integer totalCount;

        /** 总页数 */
        @JsonProperty("totalPage")
        private Integer totalPage;

        /** 当前页记录数 */
        @JsonProperty("currentCount")
        private Integer currentCount;

        public List<QueryHistoryDetailReturnObjAnomalyDetailResponse> getAnomalyDetail() {
            return this.anomalyDetail;
        }

        public void setAnomalyDetail(
                List<QueryHistoryDetailReturnObjAnomalyDetailResponse> anomalyDetail) {
            this.anomalyDetail = anomalyDetail;
        }

        public Integer getTotalCount() {
            return this.totalCount;
        }

        public void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        public Integer getTotalPage() {
            return this.totalPage;
        }

        public void setTotalPage(Integer totalPage) {
            this.totalPage = totalPage;
        }

        public Integer getCurrentCount() {
            return this.currentCount;
        }

        public void setCurrentCount(Integer currentCount) {
            this.currentCount = currentCount;
        }
    }

    public static class QueryHistoryDetailReturnObjAnomalyDetailResponse {
        /** 主机ID */
        @JsonProperty("deviceUUID")
        private String deviceUUID;

        /** 主机名称 */
        @JsonProperty("deviceName")
        private String deviceName;

        /** 监控项 */
        @JsonProperty("item")
        private String item;

        /** 异常值 */
        @JsonProperty("value")
        private Double value;

        public String getDeviceUUID() {
            return this.deviceUUID;
        }

        public void setDeviceUUID(String deviceUUID) {
            this.deviceUUID = deviceUUID;
        }

        public String getDeviceName() {
            return this.deviceName;
        }

        public void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public String getItem() {
            return this.item;
        }

        public void setItem(String item) {
            this.item = item;
        }

        public Double getValue() {
            return this.value;
        }

        public void setValue(Double value) {
            this.value = value;
        }
    }
}
