package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 调用此接口可查询巡检项。 */
public class MonitorQueryInspectionItemApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorQueryInspectionItemApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v4/monitor/intelligent-inspection/query-inspection-item",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public QueryInspectionItemResponse send(
            Credential credential, QueryInspectionItemRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.inspectionType != null) {
            ctReq.addParam("inspectionType", String.valueOf(request.inspectionType));
            request.inspectionType = null;
        }
        if (request.search != null) {
            ctReq.addParam("search", request.search);
            request.search = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(QueryInspectionItemResponse.class);
    }

    public static class QueryInspectionItemRequest {
        /**
         * 本参数表示巡检类型。取值范围：<br>
         * 1：资源健康评估。<br>
         * 2：资源风险识别。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("inspectionType")
        private Integer inspectionType;

        /** 模糊搜索 */
        @JsonProperty("search")
        private String search;

        public Integer getInspectionType() {
            return this.inspectionType;
        }

        public void setInspectionType(Integer inspectionType) {
            this.inspectionType = inspectionType;
        }

        public String getSearch() {
            return this.search;
        }

        public void setSearch(String search) {
            this.search = search;
        }
    }

    public static class QueryInspectionItemResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，一般为中文描述 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 返回参数 */
        @JsonProperty("returnObj")
        private QueryInspectionItemReturnObjResponse returnObj;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public QueryInspectionItemReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(QueryInspectionItemReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class QueryInspectionItemReturnObjResponse {
        /** 巡检项列表 */
        @JsonProperty("inspectionItemList")
        private List<QueryInspectionItemReturnObjInspectionItemListResponse> inspectionItemList;

        public List<QueryInspectionItemReturnObjInspectionItemListResponse>
                getInspectionItemList() {
            return this.inspectionItemList;
        }

        public void setInspectionItemList(
                List<QueryInspectionItemReturnObjInspectionItemListResponse> inspectionItemList) {
            this.inspectionItemList = inspectionItemList;
        }
    }

    public static class QueryInspectionItemReturnObjInspectionItemListResponse {
        /**
         * 本参数表示产品类型。取值范围：<br>
         * vm：云主机。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("productType")
        private String productType;

        /**
         * 本参数表示巡检类型。取值范围：<br>
         * 1：资源健康评估。<br>
         * 2：资源风险识别。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("inspectionType")
        private Integer inspectionType;

        /**
         * 本参数表示巡检项。取值范围：<br>
         * 1：云主机性能评估。<br>
         * 2：监控数据健康评估。<br>
         * 3：云主机闲置资源检查。<br>
         * 4：云主机磁盘使用预警评估<br>
         * 根据以上范围取值。
         */
        @JsonProperty("inspectionItem")
        private Integer inspectionItem;

        /** 本参数表示巡检项名称 */
        @JsonProperty("inspectionItemName")
        private String inspectionItemName;

        /**
         * 本参数表示重要等级。取值范围：<br>
         * 1：低。<br>
         * 2：中。<br>
         * 3：高。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("level")
        private Integer level;

        /** 巡检项描述 */
        @JsonProperty("description")
        private String description;

        /**
         * 本参数表示巡检项状态。取值范围：<br>
         * true：正常。<br>
         * false：异常。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("status")
        private Boolean status;

        /** 巡检规则列表 */
        @JsonProperty("inspectionRules")
        private List<QueryInspectionItemReturnObjInspectionItemListInspectionRulesResponse>
                inspectionRules;

        public String getProductType() {
            return this.productType;
        }

        public void setProductType(String productType) {
            this.productType = productType;
        }

        public Integer getInspectionType() {
            return this.inspectionType;
        }

        public void setInspectionType(Integer inspectionType) {
            this.inspectionType = inspectionType;
        }

        public Integer getInspectionItem() {
            return this.inspectionItem;
        }

        public void setInspectionItem(Integer inspectionItem) {
            this.inspectionItem = inspectionItem;
        }

        public String getInspectionItemName() {
            return this.inspectionItemName;
        }

        public void setInspectionItemName(String inspectionItemName) {
            this.inspectionItemName = inspectionItemName;
        }

        public Integer getLevel() {
            return this.level;
        }

        public void setLevel(Integer level) {
            this.level = level;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public Boolean getStatus() {
            return this.status;
        }

        public void setStatus(Boolean status) {
            this.status = status;
        }

        public List<QueryInspectionItemReturnObjInspectionItemListInspectionRulesResponse>
                getInspectionRules() {
            return this.inspectionRules;
        }

        public void setInspectionRules(
                List<QueryInspectionItemReturnObjInspectionItemListInspectionRulesResponse>
                        inspectionRules) {
            this.inspectionRules = inspectionRules;
        }
    }

    public static class QueryInspectionItemReturnObjInspectionItemListInspectionRulesResponse {
        /** 监控项 */
        @JsonProperty("monitorItem")
        private String monitorItem;

        /** 巡检周期，在不同巡检项中对应巡检天数或预计未来天数 */
        @JsonProperty("period")
        private Integer period;

        /**
         * 本参数表示巡检算法。取值范围：<br>
         * avg：平均值算法。<br>
         * max：最大值算法。<br>
         * min：最小值算法。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("fun")
        private String fun;

        /**
         * 本参数表示比较符。取值范围：<br>
         * eq：等于。<br>
         * gt：大于。<br>
         * ge：大于等于。<br>
         * lt：小于。<br>
         * le：小于等于。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("operator")
        private String operator;

        /** 阈值 */
        @JsonProperty("monitorValue")
        private Double monitorValue;

        public String getMonitorItem() {
            return this.monitorItem;
        }

        public void setMonitorItem(String monitorItem) {
            this.monitorItem = monitorItem;
        }

        public Integer getPeriod() {
            return this.period;
        }

        public void setPeriod(Integer period) {
            this.period = period;
        }

        public String getFun() {
            return this.fun;
        }

        public void setFun(String fun) {
            this.fun = fun;
        }

        public String getOperator() {
            return this.operator;
        }

        public void setOperator(String operator) {
            this.operator = operator;
        }

        public Double getMonitorValue() {
            return this.monitorValue;
        }

        public void setMonitorValue(Double monitorValue) {
            this.monitorValue = monitorValue;
        }
    }
}
