package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 调用此接口可查询拨测任务结果。 */
public class MonitorQueryInstantDetectionTaskApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorQueryInstantDetectionTaskApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v4/monitor/query-instant-detection-task",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public QueryInstantDetectionTaskResponse send(
            Credential credential, QueryInstantDetectionTaskRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(QueryInstantDetectionTaskResponse.class);
    }

    public static class QueryInstantDetectionTaskRequest {
        /** 任务ID */
        @JsonProperty("taskID")
        private String taskID;

        /**
         * 本参数表示拨测任务类型。取值范围：<br>
         * http：http探测。<br>
         * ping：ping探测。<br>
         * mtr：mtr探测。<br>
         * traceroute：traceroute探测。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("type")
        private String type;

        public String getTaskID() {
            return this.taskID;
        }

        public void setTaskID(String taskID) {
            this.taskID = taskID;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }

    public static class QueryInstantDetectionTaskResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，一般为中文描述 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 返回参数，参考returnObj对象结构 */
        @JsonProperty("returnObj")
        private QueryInstantDetectionTaskReturnObjResponse returnObj;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public QueryInstantDetectionTaskReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(QueryInstantDetectionTaskReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class QueryInstantDetectionTaskReturnObjResponse {
        /** 返回结果 */
        @JsonProperty("data")
        private QueryInstantDetectionTaskReturnObjDataResponse data;

        /**
         * 本参数表示任务状态码，取值范围：<br>
         * 1：运行中。<br>
         * 2：已完成。<br>
         * 3：失败。<br>
         * 4：过期。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("status")
        private Integer status;

        /**
         * 本参数表示拨测任务类型。取值范围：<br>
         * http：http探测。<br>
         * ping：ping探测。<br>
         * mtr：mtr探测。<br>
         * traceroute：traceroute探测。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("type")
        private String type;

        /** 任务耗时，单位ms */
        @JsonProperty("duration")
        private Integer duration;

        /** 创建时间，毫秒级时间戳 */
        @JsonProperty("createTime")
        private Integer createTime;

        public QueryInstantDetectionTaskReturnObjDataResponse getData() {
            return this.data;
        }

        public void setData(QueryInstantDetectionTaskReturnObjDataResponse data) {
            this.data = data;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Integer getDuration() {
            return this.duration;
        }

        public void setDuration(Integer duration) {
            this.duration = duration;
        }

        public Integer getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(Integer createTime) {
            this.createTime = createTime;
        }
    }

    public static class QueryInstantDetectionTaskReturnObjDataResponse {
        /** ping探测的返回值 */
        @JsonProperty("pingData")
        private List<QueryInstantDetectionTaskReturnObjDataPingDataResponse> pingData;

        /** http探测的返回值 */
        @JsonProperty("httpData")
        private List<QueryInstantDetectionTaskReturnObjDataHttpDataResponse> httpData;

        /** mtr探测的返回值 */
        @JsonProperty("mtrData")
        private List<QueryInstantDetectionTaskReturnObjDataMtrDataResponse> mtrData;

        /** traceroute探测的返回值 */
        @JsonProperty("tracerouteData")
        private List<QueryInstantDetectionTaskReturnObjDataTracerouteDataResponse> tracerouteData;

        public List<QueryInstantDetectionTaskReturnObjDataPingDataResponse> getPingData() {
            return this.pingData;
        }

        public void setPingData(
                List<QueryInstantDetectionTaskReturnObjDataPingDataResponse> pingData) {
            this.pingData = pingData;
        }

        public List<QueryInstantDetectionTaskReturnObjDataHttpDataResponse> getHttpData() {
            return this.httpData;
        }

        public void setHttpData(
                List<QueryInstantDetectionTaskReturnObjDataHttpDataResponse> httpData) {
            this.httpData = httpData;
        }

        public List<QueryInstantDetectionTaskReturnObjDataMtrDataResponse> getMtrData() {
            return this.mtrData;
        }

        public void setMtrData(
                List<QueryInstantDetectionTaskReturnObjDataMtrDataResponse> mtrData) {
            this.mtrData = mtrData;
        }

        public List<QueryInstantDetectionTaskReturnObjDataTracerouteDataResponse>
                getTracerouteData() {
            return this.tracerouteData;
        }

        public void setTracerouteData(
                List<QueryInstantDetectionTaskReturnObjDataTracerouteDataResponse> tracerouteData) {
            this.tracerouteData = tracerouteData;
        }
    }

    public static class QueryInstantDetectionTaskReturnObjDataPingDataResponse {
        /** 目标IP */
        @JsonProperty("targetIP")
        private String targetIP;

        /** 拨测状态 */
        @JsonProperty("status")
        private Integer status;

        /** 丢包率 */
        @JsonProperty("packetLoss")
        private Double packetLoss;

        /** 最大时间 */
        @JsonProperty("maxTime")
        private Double maxTime;

        /** 最小时间 */
        @JsonProperty("minTime")
        private Double minTime;

        /** 平均时间 */
        @JsonProperty("avgTime")
        private Double avgTime;

        /** 详情 */
        @JsonProperty("detail")
        private String detail;

        /** 拨测点ID */
        @JsonProperty("pointID")
        private String pointID;

        public String getTargetIP() {
            return this.targetIP;
        }

        public void setTargetIP(String targetIP) {
            this.targetIP = targetIP;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public Double getPacketLoss() {
            return this.packetLoss;
        }

        public void setPacketLoss(Double packetLoss) {
            this.packetLoss = packetLoss;
        }

        public Double getMaxTime() {
            return this.maxTime;
        }

        public void setMaxTime(Double maxTime) {
            this.maxTime = maxTime;
        }

        public Double getMinTime() {
            return this.minTime;
        }

        public void setMinTime(Double minTime) {
            this.minTime = minTime;
        }

        public Double getAvgTime() {
            return this.avgTime;
        }

        public void setAvgTime(Double avgTime) {
            this.avgTime = avgTime;
        }

        public String getDetail() {
            return this.detail;
        }

        public void setDetail(String detail) {
            this.detail = detail;
        }

        public String getPointID() {
            return this.pointID;
        }

        public void setPointID(String pointID) {
            this.pointID = pointID;
        }
    }

    public static class QueryInstantDetectionTaskReturnObjDataHttpDataResponse {
        /** 目标IP */
        @JsonProperty("targetIP")
        private String targetIP;

        /** 拨测状态 */
        @JsonProperty("status")
        private Integer status;

        /** 总时间（毫秒） */
        @JsonProperty("totalTime")
        private Double totalTime;

        /** 总下载大小（KB） */
        @JsonProperty("totalDownloadSize")
        private Double totalDownloadSize;

        /** 详情 */
        @JsonProperty("detail")
        private String detail;

        /** 拨测点ID */
        @JsonProperty("pointID")
        private String pointID;

        public String getTargetIP() {
            return this.targetIP;
        }

        public void setTargetIP(String targetIP) {
            this.targetIP = targetIP;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public Double getTotalTime() {
            return this.totalTime;
        }

        public void setTotalTime(Double totalTime) {
            this.totalTime = totalTime;
        }

        public Double getTotalDownloadSize() {
            return this.totalDownloadSize;
        }

        public void setTotalDownloadSize(Double totalDownloadSize) {
            this.totalDownloadSize = totalDownloadSize;
        }

        public String getDetail() {
            return this.detail;
        }

        public void setDetail(String detail) {
            this.detail = detail;
        }

        public String getPointID() {
            return this.pointID;
        }

        public void setPointID(String pointID) {
            this.pointID = pointID;
        }
    }

    public static class QueryInstantDetectionTaskReturnObjDataMtrDataResponse {
        /** 结构化数据 */
        @JsonProperty("info")
        private List<QueryInstantDetectionTaskReturnObjDataMtrDataInfoResponse> info;

        /** 目标IP */
        @JsonProperty("targetIP")
        private String targetIP;

        /** 详情 */
        @JsonProperty("detail")
        private String detail;

        /** 拨测点ID */
        @JsonProperty("pointID")
        private String pointID;

        public List<QueryInstantDetectionTaskReturnObjDataMtrDataInfoResponse> getInfo() {
            return this.info;
        }

        public void setInfo(List<QueryInstantDetectionTaskReturnObjDataMtrDataInfoResponse> info) {
            this.info = info;
        }

        public String getTargetIP() {
            return this.targetIP;
        }

        public void setTargetIP(String targetIP) {
            this.targetIP = targetIP;
        }

        public String getDetail() {
            return this.detail;
        }

        public void setDetail(String detail) {
            this.detail = detail;
        }

        public String getPointID() {
            return this.pointID;
        }

        public void setPointID(String pointID) {
            this.pointID = pointID;
        }
    }

    public static class QueryInstantDetectionTaskReturnObjDataTracerouteDataResponse {
        /** 结构化数据 */
        @JsonProperty("info")
        private List<QueryInstantDetectionTaskReturnObjDataTracerouteDataInfoResponse> info;

        /** 目标IP */
        @JsonProperty("targetIP")
        private String targetIP;

        /** 详情 */
        @JsonProperty("detail")
        private String detail;

        /** 拨测点ID */
        @JsonProperty("pointID")
        private String pointID;

        public List<QueryInstantDetectionTaskReturnObjDataTracerouteDataInfoResponse> getInfo() {
            return this.info;
        }

        public void setInfo(
                List<QueryInstantDetectionTaskReturnObjDataTracerouteDataInfoResponse> info) {
            this.info = info;
        }

        public String getTargetIP() {
            return this.targetIP;
        }

        public void setTargetIP(String targetIP) {
            this.targetIP = targetIP;
        }

        public String getDetail() {
            return this.detail;
        }

        public void setDetail(String detail) {
            this.detail = detail;
        }

        public String getPointID() {
            return this.pointID;
        }

        public void setPointID(String pointID) {
            this.pointID = pointID;
        }
    }

    public static class QueryInstantDetectionTaskReturnObjDataMtrDataInfoResponse {
        /** 序号 */
        @JsonProperty("sequence")
        private Integer sequence;

        /** 主机名称 */
        @JsonProperty("host")
        private String host;

        /** 丢包率（百分比） */
        @JsonProperty("packetLossRate")
        private Double packetLossRate;

        /** 数据包量 */
        @JsonProperty("packetCount")
        private Double packetCount;

        /** 最近一次探测用时（毫秒） */
        @JsonProperty("latestProbeTime")
        private Double latestProbeTime;

        /** 平均时间（毫秒） */
        @JsonProperty("averageTime")
        private Double averageTime;

        /** 最小时间（毫秒） */
        @JsonProperty("minTime")
        private Double minTime;

        /** 最大时间（毫秒） */
        @JsonProperty("maxTime")
        private Double maxTime;

        /** 标准偏差 */
        @JsonProperty("standardDeviation")
        private Integer standardDeviation;

        public Integer getSequence() {
            return this.sequence;
        }

        public void setSequence(Integer sequence) {
            this.sequence = sequence;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public Double getPacketLossRate() {
            return this.packetLossRate;
        }

        public void setPacketLossRate(Double packetLossRate) {
            this.packetLossRate = packetLossRate;
        }

        public Double getPacketCount() {
            return this.packetCount;
        }

        public void setPacketCount(Double packetCount) {
            this.packetCount = packetCount;
        }

        public Double getLatestProbeTime() {
            return this.latestProbeTime;
        }

        public void setLatestProbeTime(Double latestProbeTime) {
            this.latestProbeTime = latestProbeTime;
        }

        public Double getAverageTime() {
            return this.averageTime;
        }

        public void setAverageTime(Double averageTime) {
            this.averageTime = averageTime;
        }

        public Double getMinTime() {
            return this.minTime;
        }

        public void setMinTime(Double minTime) {
            this.minTime = minTime;
        }

        public Double getMaxTime() {
            return this.maxTime;
        }

        public void setMaxTime(Double maxTime) {
            this.maxTime = maxTime;
        }

        public Integer getStandardDeviation() {
            return this.standardDeviation;
        }

        public void setStandardDeviation(Integer standardDeviation) {
            this.standardDeviation = standardDeviation;
        }
    }

    public static class QueryInstantDetectionTaskReturnObjDataTracerouteDataInfoResponse {
        /** 序号 */
        @JsonProperty("sequence")
        private Integer sequence;

        /** 主机名称 */
        @JsonProperty("host")
        private String host;

        /** 总时间（毫秒） */
        @JsonProperty("totalTime")
        private Double totalTime;

        public Integer getSequence() {
            return this.sequence;
        }

        public void setSequence(Integer sequence) {
            this.sequence = sequence;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public Double getTotalTime() {
            return this.totalTime;
        }

        public void setTotalTime(Double totalTime) {
            this.totalTime = totalTime;
        }
    }
}
