package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 调用此接口可查询数据订阅列表。 */
public class MonitorQueryMessageSubscriptionApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorQueryMessageSubscriptionApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v4/monitor/query-message-subscription",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public QueryMessageSubscriptionResponse send(
            Credential credential, QueryMessageSubscriptionRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionID != null) {
            ctReq.addParam("regionID", request.regionID);
            request.regionID = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(QueryMessageSubscriptionResponse.class);
    }

    public static class QueryMessageSubscriptionRequest {
        /** 资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }
    }

    public static class QueryMessageSubscriptionResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，适配中英文 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 失败时的错误描述，适配中英文 */
        @JsonProperty("description")
        private String description;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private QueryMessageSubscriptionReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public QueryMessageSubscriptionReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(QueryMessageSubscriptionReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class QueryMessageSubscriptionReturnObjResponse {
        /** 数据订阅ID */
        @JsonProperty("subscriptionID")
        private String subscriptionID;

        /** 资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 任务名称 */
        @JsonProperty("name")
        private String name;

        /**
         * 本参数目标类型。取值范围：<br>
         * 1：kafka。<br>
         * 4：API。<br>
         * 5：remoteWrite。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("targetType")
        private Integer targetType;

        /**
         * 本参数表示状态。取值范围：<br>
         * 0：上线。<br>
         * 1：下线。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("status")
        private Integer status;

        /** 更新时间 */
        @JsonProperty("updateTime")
        private String updateTime;

        public String getSubscriptionID() {
            return this.subscriptionID;
        }

        public void setSubscriptionID(String subscriptionID) {
            this.subscriptionID = subscriptionID;
        }

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Integer getTargetType() {
            return this.targetType;
        }

        public void setTargetType(Integer targetType) {
            this.targetType = targetType;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public String getUpdateTime() {
            return this.updateTime;
        }

        public void setUpdateTime(String updateTime) {
            this.updateTime = updateTime;
        }
    }
}
