package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 根据筛选条件查询各设备类型支持的监控项的列表。 */
public class MonitorQueryMonitorItemsApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorQueryMonitorItemsApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v4/monitor/query-monitor-items",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public QueryMonitorItemsResponse send(Credential credential, QueryMonitorItemsRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.deviceType != null) {
            ctReq.addParam("deviceType", request.deviceType);
            request.deviceType = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(QueryMonitorItemsResponse.class);
    }

    public static class QueryMonitorItemsRequest {
        /**
         * 本参数表示设备类型。默认值为所有类型。取值范围：<br>
         * vm：云主机。<br>
         * bare_metal：裸金属。<br>
         * disk：云磁盘。<br>
         * scaling：弹性伸缩。<br>
         * traffic：共享带宽。<br>
         * eip：弹性IP。<br>
         * elb：负载均衡。<br>
         * listener：监听器。<br>
         * cstor_sfs：弹性文件。<br>
         * site_monitor：站点监控。<br>
         * natgw：NAT网关。<br>
         * zos_bucket：对象存储-存储桶。<br>
         * zos_user：对象存储-用户。<br>
         * vnet_monitor_endpoint_statistic：VPC终端节点。<br>
         * vnet_endpoint_service_statistic：VPC终端节点服务。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("deviceType")
        private String deviceType;

        public String getDeviceType() {
            return this.deviceType;
        }

        public void setDeviceType(String deviceType) {
            this.deviceType = deviceType;
        }
    }

    public static class QueryMonitorItemsResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，一般为中文描述 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private QueryMonitorItemsReturnObjResponse returnObj;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public QueryMonitorItemsReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(QueryMonitorItemsReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class QueryMonitorItemsReturnObjResponse {
        /** 监控资源列表 */
        @JsonProperty("monitorItems")
        private List<QueryMonitorItemsReturnObjMonitorItemsResponse> monitorItems;

        public List<QueryMonitorItemsReturnObjMonitorItemsResponse> getMonitorItems() {
            return this.monitorItems;
        }

        public void setMonitorItems(
                List<QueryMonitorItemsReturnObjMonitorItemsResponse> monitorItems) {
            this.monitorItems = monitorItems;
        }
    }

    public static class QueryMonitorItemsReturnObjMonitorItemsResponse {
        /** 监控设备类型 */
        @JsonProperty("deviceType")
        private String deviceType;

        /** 监控设备指标内容 */
        @JsonProperty("items")
        private List<QueryMonitorItemsReturnObjMonitorItemsItemsResponse> items;

        public String getDeviceType() {
            return this.deviceType;
        }

        public void setDeviceType(String deviceType) {
            this.deviceType = deviceType;
        }

        public List<QueryMonitorItemsReturnObjMonitorItemsItemsResponse> getItems() {
            return this.items;
        }

        public void setItems(List<QueryMonitorItemsReturnObjMonitorItemsItemsResponse> items) {
            this.items = items;
        }
    }

    public static class QueryMonitorItemsReturnObjMonitorItemsItemsResponse {
        /** 监控指标名称 */
        @JsonProperty("name")
        private String name;

        /** 监控指标描述 */
        @JsonProperty("desc")
        private String desc;

        /** 指标单位 */
        @JsonProperty("unit")
        private String unit;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public String getUnit() {
            return this.unit;
        }

        public void setUnit(String unit) {
            this.unit = unit;
        }
    }
}
