package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 获取资源池下服务维度信息。 */
public class MonitorQueryServiceDimensionApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorQueryServiceDimensionApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v4/monitor/events/query-services",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public QueryServiceDimensionResponse send(
            Credential credential, QueryServiceDimensionRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionID != null) {
            ctReq.addParam("regionID", request.regionID);
            request.regionID = null;
        }
        if (request.service != null) {
            ctReq.addParam("service", request.service);
            request.service = null;
        }
        if (request.monitorType != null) {
            ctReq.addParam("monitorType", request.monitorType);
            request.monitorType = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(QueryServiceDimensionResponse.class);
    }

    public static class QueryServiceDimensionRequest {
        /** 资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 服务 */
        @JsonProperty("service")
        private String service;

        /** 用于选择监控类型，如果为event则表示事件类型 */
        @JsonProperty("monitorType")
        private String monitorType;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getService() {
            return this.service;
        }

        public void setService(String service) {
            this.service = service;
        }

        public String getMonitorType() {
            return this.monitorType;
        }

        public void setMonitorType(String monitorType) {
            this.monitorType = monitorType;
        }
    }

    public static class QueryServiceDimensionResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，一般为中文描述 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private QueryServiceDimensionReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public QueryServiceDimensionReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(QueryServiceDimensionReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class QueryServiceDimensionReturnObjResponse {
        /** 服务列表 */
        @JsonProperty("services")
        private List<QueryServiceDimensionReturnObjServicesResponse> services;

        public List<QueryServiceDimensionReturnObjServicesResponse> getServices() {
            return this.services;
        }

        public void setServices(List<QueryServiceDimensionReturnObjServicesResponse> services) {
            this.services = services;
        }
    }

    public static class QueryServiceDimensionReturnObjServicesResponse {
        /** 服务 */
        @JsonProperty("service")
        private String service;

        /** 描述 */
        @JsonProperty("description")
        private String description;

        /** 维度列表 */
        @JsonProperty("dimensions")
        private List<QueryServiceDimensionReturnObjServicesDimensionsResponse> dimensions;

        public String getService() {
            return this.service;
        }

        public void setService(String service) {
            this.service = service;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public List<QueryServiceDimensionReturnObjServicesDimensionsResponse> getDimensions() {
            return this.dimensions;
        }

        public void setDimensions(
                List<QueryServiceDimensionReturnObjServicesDimensionsResponse> dimensions) {
            this.dimensions = dimensions;
        }
    }

    public static class QueryServiceDimensionReturnObjServicesDimensionsResponse {
        /** 维度 */
        @JsonProperty("dimension")
        private String dimension;

        /** 描述 */
        @JsonProperty("description")
        private String description;

        public String getDimension() {
            return this.dimension;
        }

        public void setDimension(String dimension) {
            this.dimension = dimension;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }
}
