package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 获取资源池下服务、维度、监控项信息。 */
public class MonitorQueryServiceDimensionItemApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorQueryServiceDimensionItemApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v4/monitor/query-items", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public QueryServiceDimensionItemResponse send(
            Credential credential, QueryServiceDimensionItemRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionID != null) {
            ctReq.addParam("regionID", request.regionID);
            request.regionID = null;
        }
        if (request.service != null) {
            ctReq.addParam("service", request.service);
            request.service = null;
        }
        if (request.dimension != null) {
            ctReq.addParam("dimension", request.dimension);
            request.dimension = null;
        }
        if (request.itemType != null) {
            ctReq.addParam("itemType", request.itemType);
            request.itemType = null;
        }
        if (request.isEnterpriseProject != null) {
            ctReq.addParam("isEnterpriseProject", String.valueOf(request.isEnterpriseProject));
            request.isEnterpriseProject = null;
        }
        if (request.ignoreItems != null) {
            ctReq.addParam("ignoreItems", String.valueOf(request.ignoreItems));
            request.ignoreItems = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(QueryServiceDimensionItemResponse.class);
    }

    public static class QueryServiceDimensionItemRequest {
        /** 资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 云监控服务，取值范围：参见本接口返回 */
        @JsonProperty("service")
        private String service;

        /** 云监控维度，取值范围：参见本接口返回 */
        @JsonProperty("dimension")
        private String dimension;

        /**
         * 本参数表示监控项类型。不传返回全部类型。取值范围：<br>
         * series：指标类型。<br>
         * event：事件类型。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("itemType")
        private String itemType;

        /** 是否支持企业项目 */
        @JsonProperty("isEnterpriseProject")
        private Boolean isEnterpriseProject;

        /** 是否展示监控项详情，默认值：false，展示监控项详情。 */
        @JsonProperty("ignoreItems")
        private Boolean ignoreItems;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getService() {
            return this.service;
        }

        public void setService(String service) {
            this.service = service;
        }

        public String getDimension() {
            return this.dimension;
        }

        public void setDimension(String dimension) {
            this.dimension = dimension;
        }

        public String getItemType() {
            return this.itemType;
        }

        public void setItemType(String itemType) {
            this.itemType = itemType;
        }

        public Boolean getIsEnterpriseProject() {
            return this.isEnterpriseProject;
        }

        public void setIsEnterpriseProject(Boolean isEnterpriseProject) {
            this.isEnterpriseProject = isEnterpriseProject;
        }

        public Boolean getIgnoreItems() {
            return this.ignoreItems;
        }

        public void setIgnoreItems(Boolean ignoreItems) {
            this.ignoreItems = ignoreItems;
        }
    }

    public static class QueryServiceDimensionItemResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，一般为中文描述 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private QueryServiceDimensionItemReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public QueryServiceDimensionItemReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(QueryServiceDimensionItemReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class QueryServiceDimensionItemReturnObjResponse {
        /** 统计信息列表 */
        @JsonProperty("data")
        private List<QueryServiceDimensionItemReturnObjDataResponse> data;

        public List<QueryServiceDimensionItemReturnObjDataResponse> getData() {
            return this.data;
        }

        public void setData(List<QueryServiceDimensionItemReturnObjDataResponse> data) {
            this.data = data;
        }
    }

    public static class QueryServiceDimensionItemReturnObjDataResponse {
        /** 云监控服务 */
        @JsonProperty("service")
        private String service;

        /** 描述 */
        @JsonProperty("description")
        private String description;

        /** 维度列表 */
        @JsonProperty("dimensions")
        private List<QueryServiceDimensionItemReturnObjDataDimensionsResponse> dimensions;

        /** 服务下监控项数量 */
        @JsonProperty("serviceCount")
        private Integer serviceCount;

        public String getService() {
            return this.service;
        }

        public void setService(String service) {
            this.service = service;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public List<QueryServiceDimensionItemReturnObjDataDimensionsResponse> getDimensions() {
            return this.dimensions;
        }

        public void setDimensions(
                List<QueryServiceDimensionItemReturnObjDataDimensionsResponse> dimensions) {
            this.dimensions = dimensions;
        }

        public Integer getServiceCount() {
            return this.serviceCount;
        }

        public void setServiceCount(Integer serviceCount) {
            this.serviceCount = serviceCount;
        }
    }

    public static class QueryServiceDimensionItemReturnObjDataDimensionsResponse {
        /** 云监控维度 */
        @JsonProperty("dimension")
        private String dimension;

        /** 描述 */
        @JsonProperty("description")
        private String description;

        /** 监控资源列表 */
        @JsonProperty("monitorItems")
        private List<QueryServiceDimensionItemReturnObjDataDimensionsMonitorItemsResponse>
                monitorItems;

        /** 维度下监控项数量 */
        @JsonProperty("dimensionCount")
        private Integer dimensionCount;

        public String getDimension() {
            return this.dimension;
        }

        public void setDimension(String dimension) {
            this.dimension = dimension;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public List<QueryServiceDimensionItemReturnObjDataDimensionsMonitorItemsResponse>
                getMonitorItems() {
            return this.monitorItems;
        }

        public void setMonitorItems(
                List<QueryServiceDimensionItemReturnObjDataDimensionsMonitorItemsResponse>
                        monitorItems) {
            this.monitorItems = monitorItems;
        }

        public Integer getDimensionCount() {
            return this.dimensionCount;
        }

        public void setDimensionCount(Integer dimensionCount) {
            this.dimensionCount = dimensionCount;
        }
    }

    public static class QueryServiceDimensionItemReturnObjDataDimensionsMonitorItemsResponse {
        /** 监控项的key */
        @JsonProperty("name")
        private String name;

        /** 监控项名称 */
        @JsonProperty("metricName")
        private String metricName;

        /** 监控指标描述 */
        @JsonProperty("description")
        private String description;

        /** 指标单位 */
        @JsonProperty("unit")
        private String unit;

        /** 单位转换字典 */
        @JsonProperty("unitRelations")
        private List<
                        QueryServiceDimensionItemReturnObjDataDimensionsMonitorItemsUnitRelationsResponse>
                unitRelations;

        /** 设备标签列表 */
        @JsonProperty("dimensions")
        private List<String> dimensions;

        /**
         * 本参数表示是否支持告警。取值范围：<br>
         * 0：不支持。<br>
         * 1：支持。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("isAlarm")
        private Integer isAlarm;

        /**
         * 本参数表示是否为事件类型。取值范围：<br>
         * 0：事件类型。<br>
         * 1：指标类型。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("isEvent")
        private Integer isEvent;

        /** 上报周期 */
        @JsonProperty("period")
        private Integer period;

        /**
         * 本参数表示趋势计算类型。取值范围：<br>
         * max：最大值。<br>
         * min：最小值。<br>
         * avg：平均值。<br>
         * sum：求和。<br>
         * var：方差。<br>
         * origin：原始值。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("statistics")
        private List<String> statistics;

        /**
         * 本参数表示监控项类型。取值范围：<br>
         * 0：实例指标。<br>
         * 1：分组指标。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("itemType")
        private Integer itemType;

        /** 监控类英文名 */
        @JsonProperty("metricClass")
        private String metricClass;

        /** 监控类名称 */
        @JsonProperty("metricClassName")
        private String metricClassName;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getMetricName() {
            return this.metricName;
        }

        public void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getUnit() {
            return this.unit;
        }

        public void setUnit(String unit) {
            this.unit = unit;
        }

        public List<
                        QueryServiceDimensionItemReturnObjDataDimensionsMonitorItemsUnitRelationsResponse>
                getUnitRelations() {
            return this.unitRelations;
        }

        public void setUnitRelations(
                List<
                                QueryServiceDimensionItemReturnObjDataDimensionsMonitorItemsUnitRelationsResponse>
                        unitRelations) {
            this.unitRelations = unitRelations;
        }

        public List<String> getDimensions() {
            return this.dimensions;
        }

        public void setDimensions(List<String> dimensions) {
            this.dimensions = dimensions;
        }

        public Integer getIsAlarm() {
            return this.isAlarm;
        }

        public void setIsAlarm(Integer isAlarm) {
            this.isAlarm = isAlarm;
        }

        public Integer getIsEvent() {
            return this.isEvent;
        }

        public void setIsEvent(Integer isEvent) {
            this.isEvent = isEvent;
        }

        public Integer getPeriod() {
            return this.period;
        }

        public void setPeriod(Integer period) {
            this.period = period;
        }

        public List<String> getStatistics() {
            return this.statistics;
        }

        public void setStatistics(List<String> statistics) {
            this.statistics = statistics;
        }

        public Integer getItemType() {
            return this.itemType;
        }

        public void setItemType(Integer itemType) {
            this.itemType = itemType;
        }

        public String getMetricClass() {
            return this.metricClass;
        }

        public void setMetricClass(String metricClass) {
            this.metricClass = metricClass;
        }

        public String getMetricClassName() {
            return this.metricClassName;
        }

        public void setMetricClassName(String metricClassName) {
            this.metricClassName = metricClassName;
        }
    }

    public static
    class QueryServiceDimensionItemReturnObjDataDimensionsMonitorItemsUnitRelationsResponse {
        /** 单位 */
        @JsonProperty("unit")
        private String unit;

        /** 权重 */
        @JsonProperty("weight")
        private Double weight;

        public String getUnit() {
            return this.unit;
        }

        public void setUnit(String unit) {
            this.unit = unit;
        }

        public Double getWeight() {
            return this.weight;
        }

        public void setWeight(Double weight) {
            this.weight = weight;
        }
    }
}
