package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询看板下某个视图的数据。 */
public class MonitorQueryViewDataOfMonitorBoardApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorQueryViewDataOfMonitorBoardApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v4/monitor/monitor-board/query-view-data",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public QueryViewDataOfMonitorBoardResponse send(
            Credential credential, QueryViewDataOfMonitorBoardRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(QueryViewDataOfMonitorBoardResponse.class);
    }

    public static class QueryViewDataOfMonitorBoardRequest {
        /** 资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 面板ID */
        @JsonProperty("viewID")
        private String viewID;

        /** 查询起始Unix时间戳, startTime和endTime成对使用，且时间间隔不超过31天 */
        @JsonProperty("startTime")
        private Integer startTime;

        /** 查询结束Unix时间戳， startTime和endTime成对使用，且时间间隔不超过31天 */
        @JsonProperty("endTime")
        private Integer endTime;

        /**
         * 本参数表示聚合类型。默认值为avg。取值范围:<br>
         * raw：原始值。<br>
         * avg：平均值。<br>
         * min：最小值。<br>
         * max：最大值。<br>
         * variance：方差。<br>
         * sum：求和。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("fun")
        private String fun;

        /** 聚合周期，单位：秒，默认300，需不小于60，推荐使用60的整倍数。当fun为raw时本参数无效。 */
        @JsonProperty("period")
        private Integer period;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getViewID() {
            return this.viewID;
        }

        public void setViewID(String viewID) {
            this.viewID = viewID;
        }

        public Integer getStartTime() {
            return this.startTime;
        }

        public void setStartTime(Integer startTime) {
            this.startTime = startTime;
        }

        public Integer getEndTime() {
            return this.endTime;
        }

        public void setEndTime(Integer endTime) {
            this.endTime = endTime;
        }

        public String getFun() {
            return this.fun;
        }

        public void setFun(String fun) {
            this.fun = fun;
        }

        public Integer getPeriod() {
            return this.period;
        }

        public void setPeriod(Integer period) {
            this.period = period;
        }
    }

    public static class QueryViewDataOfMonitorBoardResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，适配中英文 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 失败时的错误描述，适配中英文 */
        @JsonProperty("description")
        private String description;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private QueryViewDataOfMonitorBoardReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public QueryViewDataOfMonitorBoardReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(QueryViewDataOfMonitorBoardReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class QueryViewDataOfMonitorBoardReturnObjResponse {
        /** 视图ID */
        @JsonProperty("viewID")
        private String viewID;

        /**
         * 视图类型。取值范围:<br>
         * timeSeries：折线图。<br>
         * gauge：仪表盘。<br>
         * barChart：柱状图。<br>
         * table：表格。<br>
         * pieChart：饼状图。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("viewType")
        private String viewType;

        /**
         * 视图属性。取值范围:<br>
         * metric：指标。<br>
         * resource：实例。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("monitorType")
        private String monitorType;

        /** 数据 */
        @JsonProperty("viewData")
        private QueryViewDataOfMonitorBoardReturnObjViewDataResponse viewData;

        public String getViewID() {
            return this.viewID;
        }

        public void setViewID(String viewID) {
            this.viewID = viewID;
        }

        public String getViewType() {
            return this.viewType;
        }

        public void setViewType(String viewType) {
            this.viewType = viewType;
        }

        public String getMonitorType() {
            return this.monitorType;
        }

        public void setMonitorType(String monitorType) {
            this.monitorType = monitorType;
        }

        public QueryViewDataOfMonitorBoardReturnObjViewDataResponse getViewData() {
            return this.viewData;
        }

        public void setViewData(QueryViewDataOfMonitorBoardReturnObjViewDataResponse viewData) {
            this.viewData = viewData;
        }
    }

    public static class QueryViewDataOfMonitorBoardReturnObjViewDataResponse {
        /** 折线图数据 */
        @JsonProperty("timeSeriesData")
        private List<QueryViewDataOfMonitorBoardReturnObjViewDataTimeSeriesDataResponse>
                timeSeriesData;

        /** 柱状图数据 */
        @JsonProperty("barChartData")
        private List<QueryViewDataOfMonitorBoardReturnObjViewDataBarChartDataResponse> barChartData;

        /** 仪表盘数据 */
        @JsonProperty("gaugeData")
        private QueryViewDataOfMonitorBoardReturnObjViewDataGaugeDataResponse gaugeData;

        /** 饼状图数据 */
        @JsonProperty("pieChartData")
        private QueryViewDataOfMonitorBoardReturnObjViewDataPieChartDataResponse pieChartData;

        /** 表格数据 */
        @JsonProperty("tableData")
        private QueryViewDataOfMonitorBoardReturnObjViewDataTableDataResponse tableData;

        public List<QueryViewDataOfMonitorBoardReturnObjViewDataTimeSeriesDataResponse>
                getTimeSeriesData() {
            return this.timeSeriesData;
        }

        public void setTimeSeriesData(
                List<QueryViewDataOfMonitorBoardReturnObjViewDataTimeSeriesDataResponse>
                        timeSeriesData) {
            this.timeSeriesData = timeSeriesData;
        }

        public List<QueryViewDataOfMonitorBoardReturnObjViewDataBarChartDataResponse>
                getBarChartData() {
            return this.barChartData;
        }

        public void setBarChartData(
                List<QueryViewDataOfMonitorBoardReturnObjViewDataBarChartDataResponse>
                        barChartData) {
            this.barChartData = barChartData;
        }

        public QueryViewDataOfMonitorBoardReturnObjViewDataGaugeDataResponse getGaugeData() {
            return this.gaugeData;
        }

        public void setGaugeData(
                QueryViewDataOfMonitorBoardReturnObjViewDataGaugeDataResponse gaugeData) {
            this.gaugeData = gaugeData;
        }

        public QueryViewDataOfMonitorBoardReturnObjViewDataPieChartDataResponse getPieChartData() {
            return this.pieChartData;
        }

        public void setPieChartData(
                QueryViewDataOfMonitorBoardReturnObjViewDataPieChartDataResponse pieChartData) {
            this.pieChartData = pieChartData;
        }

        public QueryViewDataOfMonitorBoardReturnObjViewDataTableDataResponse getTableData() {
            return this.tableData;
        }

        public void setTableData(
                QueryViewDataOfMonitorBoardReturnObjViewDataTableDataResponse tableData) {
            this.tableData = tableData;
        }
    }

    public static class QueryViewDataOfMonitorBoardReturnObjViewDataTimeSeriesDataResponse {
        /** 监控项名称 */
        @JsonProperty("itemName")
        private String itemName;

        /** 监控项中文介绍 */
        @JsonProperty("itemDesc")
        private String itemDesc;

        /** 监控项单位 */
        @JsonProperty("itemUnit")
        private String itemUnit;

        /**
         * 本参数表示比较类型。取值范围:<br>
         * 1d：环比。<br>
         * 7d：同比。<br>
         * 0d：原始。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("compareType")
        private String compareType;

        /** 折线图数据 */
        @JsonProperty("itemData")
        private List<QueryViewDataOfMonitorBoardReturnObjViewDataTimeSeriesDataItemDataResponse>
                itemData;

        /** 监控项标签 */
        @JsonProperty("dimensions")
        private List<QueryViewDataOfMonitorBoardReturnObjViewDataTimeSeriesDataDimensionsResponse>
                dimensions;

        /** 资源 */
        @JsonProperty("resource")
        private List<QueryViewDataOfMonitorBoardReturnObjViewDataTimeSeriesDataResourceResponse>
                resource;

        public String getItemName() {
            return this.itemName;
        }

        public void setItemName(String itemName) {
            this.itemName = itemName;
        }

        public String getItemDesc() {
            return this.itemDesc;
        }

        public void setItemDesc(String itemDesc) {
            this.itemDesc = itemDesc;
        }

        public String getItemUnit() {
            return this.itemUnit;
        }

        public void setItemUnit(String itemUnit) {
            this.itemUnit = itemUnit;
        }

        public String getCompareType() {
            return this.compareType;
        }

        public void setCompareType(String compareType) {
            this.compareType = compareType;
        }

        public List<QueryViewDataOfMonitorBoardReturnObjViewDataTimeSeriesDataItemDataResponse>
                getItemData() {
            return this.itemData;
        }

        public void setItemData(
                List<QueryViewDataOfMonitorBoardReturnObjViewDataTimeSeriesDataItemDataResponse>
                        itemData) {
            this.itemData = itemData;
        }

        public List<QueryViewDataOfMonitorBoardReturnObjViewDataTimeSeriesDataDimensionsResponse>
                getDimensions() {
            return this.dimensions;
        }

        public void setDimensions(
                List<QueryViewDataOfMonitorBoardReturnObjViewDataTimeSeriesDataDimensionsResponse>
                        dimensions) {
            this.dimensions = dimensions;
        }

        public List<QueryViewDataOfMonitorBoardReturnObjViewDataTimeSeriesDataResourceResponse>
                getResource() {
            return this.resource;
        }

        public void setResource(
                List<QueryViewDataOfMonitorBoardReturnObjViewDataTimeSeriesDataResourceResponse>
                        resource) {
            this.resource = resource;
        }
    }

    public static class QueryViewDataOfMonitorBoardReturnObjViewDataBarChartDataResponse {
        /** 监控项名称 */
        @JsonProperty("itemName")
        private String itemName;

        /** 监控项中文介绍 */
        @JsonProperty("itemDesc")
        private String itemDesc;

        /** 监控项单位 */
        @JsonProperty("itemUnit")
        private String itemUnit;

        /**
         * 本参数表示比较类型。取值范围:<br>
         * 1d：环比。<br>
         * 7d：同比。<br>
         * 0d：原始。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("compareType")
        private String compareType;

        /** 柱状图数据 */
        @JsonProperty("itemData")
        private List<QueryViewDataOfMonitorBoardReturnObjViewDataBarChartDataItemDataResponse>
                itemData;

        /** 监控项标签 */
        @JsonProperty("dimensions")
        private List<QueryViewDataOfMonitorBoardReturnObjViewDataBarChartDataDimensionsResponse>
                dimensions;

        /** 资源 */
        @JsonProperty("resource")
        private List<QueryViewDataOfMonitorBoardReturnObjViewDataBarChartDataResourceResponse>
                resource;

        public String getItemName() {
            return this.itemName;
        }

        public void setItemName(String itemName) {
            this.itemName = itemName;
        }

        public String getItemDesc() {
            return this.itemDesc;
        }

        public void setItemDesc(String itemDesc) {
            this.itemDesc = itemDesc;
        }

        public String getItemUnit() {
            return this.itemUnit;
        }

        public void setItemUnit(String itemUnit) {
            this.itemUnit = itemUnit;
        }

        public String getCompareType() {
            return this.compareType;
        }

        public void setCompareType(String compareType) {
            this.compareType = compareType;
        }

        public List<QueryViewDataOfMonitorBoardReturnObjViewDataBarChartDataItemDataResponse>
                getItemData() {
            return this.itemData;
        }

        public void setItemData(
                List<QueryViewDataOfMonitorBoardReturnObjViewDataBarChartDataItemDataResponse>
                        itemData) {
            this.itemData = itemData;
        }

        public List<QueryViewDataOfMonitorBoardReturnObjViewDataBarChartDataDimensionsResponse>
                getDimensions() {
            return this.dimensions;
        }

        public void setDimensions(
                List<QueryViewDataOfMonitorBoardReturnObjViewDataBarChartDataDimensionsResponse>
                        dimensions) {
            this.dimensions = dimensions;
        }

        public List<QueryViewDataOfMonitorBoardReturnObjViewDataBarChartDataResourceResponse>
                getResource() {
            return this.resource;
        }

        public void setResource(
                List<QueryViewDataOfMonitorBoardReturnObjViewDataBarChartDataResourceResponse>
                        resource) {
            this.resource = resource;
        }
    }

    public static class QueryViewDataOfMonitorBoardReturnObjViewDataGaugeDataResponse {
        /** 监控项名称 */
        @JsonProperty("itemName")
        private String itemName;

        /** 监控项中文介绍 */
        @JsonProperty("itemDesc")
        private String itemDesc;

        /** 监控项单位 */
        @JsonProperty("itemUnit")
        private String itemUnit;

        /** 监控项原始值 */
        @JsonProperty("rawValue")
        private String rawValue;

        /** 比较数据 */
        @JsonProperty("compareData")
        private List<QueryViewDataOfMonitorBoardReturnObjViewDataGaugeDataCompareDataResponse>
                compareData;

        /** 表盘最小值 */
        @JsonProperty("minValue")
        private Integer minValue;

        /** 表盘最大值 */
        @JsonProperty("maxValue")
        private Integer maxValue;

        /** 表盘阈值 */
        @JsonProperty("threshold")
        private List<Integer> threshold;

        /** 资源 */
        @JsonProperty("resource")
        private List<QueryViewDataOfMonitorBoardReturnObjViewDataGaugeDataResourceResponse>
                resource;

        public String getItemName() {
            return this.itemName;
        }

        public void setItemName(String itemName) {
            this.itemName = itemName;
        }

        public String getItemDesc() {
            return this.itemDesc;
        }

        public void setItemDesc(String itemDesc) {
            this.itemDesc = itemDesc;
        }

        public String getItemUnit() {
            return this.itemUnit;
        }

        public void setItemUnit(String itemUnit) {
            this.itemUnit = itemUnit;
        }

        public String getRawValue() {
            return this.rawValue;
        }

        public void setRawValue(String rawValue) {
            this.rawValue = rawValue;
        }

        public List<QueryViewDataOfMonitorBoardReturnObjViewDataGaugeDataCompareDataResponse>
                getCompareData() {
            return this.compareData;
        }

        public void setCompareData(
                List<QueryViewDataOfMonitorBoardReturnObjViewDataGaugeDataCompareDataResponse>
                        compareData) {
            this.compareData = compareData;
        }

        public Integer getMinValue() {
            return this.minValue;
        }

        public void setMinValue(Integer minValue) {
            this.minValue = minValue;
        }

        public Integer getMaxValue() {
            return this.maxValue;
        }

        public void setMaxValue(Integer maxValue) {
            this.maxValue = maxValue;
        }

        public List<Integer> getThreshold() {
            return this.threshold;
        }

        public void setThreshold(List<Integer> threshold) {
            this.threshold = threshold;
        }

        public List<QueryViewDataOfMonitorBoardReturnObjViewDataGaugeDataResourceResponse>
                getResource() {
            return this.resource;
        }

        public void setResource(
                List<QueryViewDataOfMonitorBoardReturnObjViewDataGaugeDataResourceResponse>
                        resource) {
            this.resource = resource;
        }
    }

    public static class QueryViewDataOfMonitorBoardReturnObjViewDataPieChartDataResponse {
        /** 监控项名称 */
        @JsonProperty("itemName")
        private String itemName;

        /** 监控项中文介绍 */
        @JsonProperty("itemDesc")
        private String itemDesc;

        /** 监控项单位 */
        @JsonProperty("itemUnit")
        private String itemUnit;

        /** 饼图数据 */
        @JsonProperty("itemData")
        private List<QueryViewDataOfMonitorBoardReturnObjViewDataPieChartDataItemDataResponse>
                itemData;

        public String getItemName() {
            return this.itemName;
        }

        public void setItemName(String itemName) {
            this.itemName = itemName;
        }

        public String getItemDesc() {
            return this.itemDesc;
        }

        public void setItemDesc(String itemDesc) {
            this.itemDesc = itemDesc;
        }

        public String getItemUnit() {
            return this.itemUnit;
        }

        public void setItemUnit(String itemUnit) {
            this.itemUnit = itemUnit;
        }

        public List<QueryViewDataOfMonitorBoardReturnObjViewDataPieChartDataItemDataResponse>
                getItemData() {
            return this.itemData;
        }

        public void setItemData(
                List<QueryViewDataOfMonitorBoardReturnObjViewDataPieChartDataItemDataResponse>
                        itemData) {
            this.itemData = itemData;
        }
    }

    public static class QueryViewDataOfMonitorBoardReturnObjViewDataTableDataResponse {
        /** 表头 */
        @JsonProperty("tableHead")
        private List<String> tableHead;

        /** 表格数据 */
        @JsonProperty("itemData")
        private List<QueryViewDataOfMonitorBoardReturnObjViewDataTableDataItemDataResponse>
                itemData;

        public List<String> getTableHead() {
            return this.tableHead;
        }

        public void setTableHead(List<String> tableHead) {
            this.tableHead = tableHead;
        }

        public List<QueryViewDataOfMonitorBoardReturnObjViewDataTableDataItemDataResponse>
                getItemData() {
            return this.itemData;
        }

        public void setItemData(
                List<QueryViewDataOfMonitorBoardReturnObjViewDataTableDataItemDataResponse>
                        itemData) {
            this.itemData = itemData;
        }
    }

    public static class QueryViewDataOfMonitorBoardReturnObjViewDataTimeSeriesDataItemDataResponse {
        /** 监控项值，具体请参考对应监控项文档 */
        @JsonProperty("value")
        private Double value;

        /** 监控数据Unix时间戳 */
        @JsonProperty("timestamp")
        private Integer timestamp;

        public Double getValue() {
            return this.value;
        }

        public void setValue(Double value) {
            this.value = value;
        }

        public Integer getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(Integer timestamp) {
            this.timestamp = timestamp;
        }
    }

    public static
    class QueryViewDataOfMonitorBoardReturnObjViewDataTimeSeriesDataDimensionsResponse {
        /** 监控项标签键 */
        @JsonProperty("name")
        private String name;

        /** 监控项标签键对应的值 */
        @JsonProperty("value")
        private String value;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class QueryViewDataOfMonitorBoardReturnObjViewDataTimeSeriesDataResourceResponse {
        /** 资源键 */
        @JsonProperty("key")
        private String key;

        /** 资源键对应的值 */
        @JsonProperty("value")
        private String value;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class QueryViewDataOfMonitorBoardReturnObjViewDataBarChartDataItemDataResponse {
        /** 监控项值，具体请参考对应监控项文档 */
        @JsonProperty("value")
        private Double value;

        /** 监控数据Unix时间戳 */
        @JsonProperty("timestamp")
        private Integer timestamp;

        public Double getValue() {
            return this.value;
        }

        public void setValue(Double value) {
            this.value = value;
        }

        public Integer getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(Integer timestamp) {
            this.timestamp = timestamp;
        }
    }

    public static class QueryViewDataOfMonitorBoardReturnObjViewDataBarChartDataDimensionsResponse {
        /** 监控项标签键 */
        @JsonProperty("name")
        private String name;

        /** 监控项标签键对应的值 */
        @JsonProperty("value")
        private String value;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class QueryViewDataOfMonitorBoardReturnObjViewDataBarChartDataResourceResponse {
        /** 资源键 */
        @JsonProperty("key")
        private String key;

        /** 资源键对应的值 */
        @JsonProperty("value")
        private String value;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class QueryViewDataOfMonitorBoardReturnObjViewDataGaugeDataCompareDataResponse {
        /** 监控项值，具体请参考对应监控项文档 */
        @JsonProperty("value")
        private String value;

        /**
         * 本参数表示比较类型。取值范围:<br>
         * 1d：环比。<br>
         * 7d：同比。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("compareType")
        private String compareType;

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getCompareType() {
            return this.compareType;
        }

        public void setCompareType(String compareType) {
            this.compareType = compareType;
        }
    }

    public static class QueryViewDataOfMonitorBoardReturnObjViewDataGaugeDataResourceResponse {
        /** 资源键 */
        @JsonProperty("key")
        private String key;

        /** 资源键对应的值 */
        @JsonProperty("value")
        private String value;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class QueryViewDataOfMonitorBoardReturnObjViewDataPieChartDataItemDataResponse {
        /** 监控项原始值 */
        @JsonProperty("rawValue")
        private Double rawValue;

        /** 比较数据 */
        @JsonProperty("compareData")
        private List<
                        QueryViewDataOfMonitorBoardReturnObjViewDataPieChartDataItemDataCompareDataResponse>
                compareData;

        /** 资源 */
        @JsonProperty("resource")
        private List<
                        QueryViewDataOfMonitorBoardReturnObjViewDataPieChartDataItemDataResourceResponse>
                resource;

        /** 占比 */
        @JsonProperty("proportion")
        private String proportion;

        public Double getRawValue() {
            return this.rawValue;
        }

        public void setRawValue(Double rawValue) {
            this.rawValue = rawValue;
        }

        public List<
                        QueryViewDataOfMonitorBoardReturnObjViewDataPieChartDataItemDataCompareDataResponse>
                getCompareData() {
            return this.compareData;
        }

        public void setCompareData(
                List<
                                QueryViewDataOfMonitorBoardReturnObjViewDataPieChartDataItemDataCompareDataResponse>
                        compareData) {
            this.compareData = compareData;
        }

        public List<
                        QueryViewDataOfMonitorBoardReturnObjViewDataPieChartDataItemDataResourceResponse>
                getResource() {
            return this.resource;
        }

        public void setResource(
                List<
                                QueryViewDataOfMonitorBoardReturnObjViewDataPieChartDataItemDataResourceResponse>
                        resource) {
            this.resource = resource;
        }

        public String getProportion() {
            return this.proportion;
        }

        public void setProportion(String proportion) {
            this.proportion = proportion;
        }
    }

    public static class QueryViewDataOfMonitorBoardReturnObjViewDataTableDataItemDataResponse {
        /** 服务 */
        @JsonProperty("service")
        private String service;

        /** 维度 */
        @JsonProperty("dimension")
        private String dimension;

        /** 监控项标签 */
        @JsonProperty("dimensions")
        private List<
                        QueryViewDataOfMonitorBoardReturnObjViewDataTableDataItemDataDimensionsResponse>
                dimensions;

        /** 监控数据Unix时间戳 */
        @JsonProperty("timestamp")
        private Integer timestamp;

        /** 监控项名称 */
        @JsonProperty("itemName")
        private String itemName;

        /** 监控项中文介绍 */
        @JsonProperty("itemDesc")
        private String itemDesc;

        /** 监控项单位 */
        @JsonProperty("itemUnit")
        private String itemUnit;

        /** 监控项原始值 */
        @JsonProperty("rawValue")
        private Double rawValue;

        /** 比较数据 */
        @JsonProperty("compareData")
        private List<
                        QueryViewDataOfMonitorBoardReturnObjViewDataTableDataItemDataCompareDataResponse>
                compareData;

        /** 资源 */
        @JsonProperty("resource")
        private List<QueryViewDataOfMonitorBoardReturnObjViewDataTableDataItemDataResourceResponse>
                resource;

        public String getService() {
            return this.service;
        }

        public void setService(String service) {
            this.service = service;
        }

        public String getDimension() {
            return this.dimension;
        }

        public void setDimension(String dimension) {
            this.dimension = dimension;
        }

        public List<QueryViewDataOfMonitorBoardReturnObjViewDataTableDataItemDataDimensionsResponse>
                getDimensions() {
            return this.dimensions;
        }

        public void setDimensions(
                List<
                                QueryViewDataOfMonitorBoardReturnObjViewDataTableDataItemDataDimensionsResponse>
                        dimensions) {
            this.dimensions = dimensions;
        }

        public Integer getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(Integer timestamp) {
            this.timestamp = timestamp;
        }

        public String getItemName() {
            return this.itemName;
        }

        public void setItemName(String itemName) {
            this.itemName = itemName;
        }

        public String getItemDesc() {
            return this.itemDesc;
        }

        public void setItemDesc(String itemDesc) {
            this.itemDesc = itemDesc;
        }

        public String getItemUnit() {
            return this.itemUnit;
        }

        public void setItemUnit(String itemUnit) {
            this.itemUnit = itemUnit;
        }

        public Double getRawValue() {
            return this.rawValue;
        }

        public void setRawValue(Double rawValue) {
            this.rawValue = rawValue;
        }

        public List<
                        QueryViewDataOfMonitorBoardReturnObjViewDataTableDataItemDataCompareDataResponse>
                getCompareData() {
            return this.compareData;
        }

        public void setCompareData(
                List<
                                QueryViewDataOfMonitorBoardReturnObjViewDataTableDataItemDataCompareDataResponse>
                        compareData) {
            this.compareData = compareData;
        }

        public List<QueryViewDataOfMonitorBoardReturnObjViewDataTableDataItemDataResourceResponse>
                getResource() {
            return this.resource;
        }

        public void setResource(
                List<QueryViewDataOfMonitorBoardReturnObjViewDataTableDataItemDataResourceResponse>
                        resource) {
            this.resource = resource;
        }
    }

    public static
    class QueryViewDataOfMonitorBoardReturnObjViewDataPieChartDataItemDataCompareDataResponse {
        /** 监控项值，具体请参考对应监控项文档 */
        @JsonProperty("value")
        private String value;

        /**
         * 本参数表示比较类型。取值范围:<br>
         * 1d：环比。<br>
         * 7d：同比。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("compareType")
        private String compareType;

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getCompareType() {
            return this.compareType;
        }

        public void setCompareType(String compareType) {
            this.compareType = compareType;
        }
    }

    public static
    class QueryViewDataOfMonitorBoardReturnObjViewDataPieChartDataItemDataResourceResponse {
        /** 资源键 */
        @JsonProperty("key")
        private String key;

        /** 资源键对应的值 */
        @JsonProperty("value")
        private String value;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static
    class QueryViewDataOfMonitorBoardReturnObjViewDataTableDataItemDataDimensionsResponse {
        /** 监控项标签键 */
        @JsonProperty("name")
        private String name;

        /** 监控项标签键对应的值 */
        @JsonProperty("value")
        private String value;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static
    class QueryViewDataOfMonitorBoardReturnObjViewDataTableDataItemDataCompareDataResponse {
        /** 监控项值，具体请参考对应监控项文档 */
        @JsonProperty("value")
        private String value;

        /**
         * 本参数表示比较类型。取值范围:<br>
         * 1d：环比。<br>
         * 7d：同比。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("compareType")
        private String compareType;

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getCompareType() {
            return this.compareType;
        }

        public void setCompareType(String compareType) {
            this.compareType = compareType;
        }
    }

    public static
    class QueryViewDataOfMonitorBoardReturnObjViewDataTableDataItemDataResourceResponse {
        /** 资源键 */
        @JsonProperty("key")
        private String key;

        /** 资源键对应的值 */
        @JsonProperty("value")
        private String value;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}
