package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 调用此接口可刷新告警联系人组token。 */
public class MonitorRefreshTokenOfContactGroupsApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorRefreshTokenOfContactGroupsApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v4/monitor/refresh-token", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public RefreshTokenOfContactGroupsResponse send(
            Credential credential, RefreshTokenOfContactGroupsRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.contactGroupID != null) {
            ctReq.addParam("contactGroupID", request.contactGroupID);
            request.contactGroupID = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(RefreshTokenOfContactGroupsResponse.class);
    }

    public static class RefreshTokenOfContactGroupsRequest {
        /** 告警联系人组ID */
        @JsonProperty("contactGroupID")
        private String contactGroupID;

        public String getContactGroupID() {
            return this.contactGroupID;
        }

        public void setContactGroupID(String contactGroupID) {
            this.contactGroupID = contactGroupID;
        }
    }

    public static class RefreshTokenOfContactGroupsResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，一般为中文描述 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 返回参数 */
        @JsonProperty("returnObj")
        private RefreshTokenOfContactGroupsReturnObjResponse returnObj;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public RefreshTokenOfContactGroupsReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(RefreshTokenOfContactGroupsReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class RefreshTokenOfContactGroupsReturnObjResponse {
        /** token */
        @JsonProperty("token")
        private String token;

        public String getToken() {
            return this.token;
        }

        public void setToken(String token) {
            this.token = token;
        }
    }
}
