package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 调用此接口可更新数据订阅。 */
public class MonitorUpdateMessageSubscriptionApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorUpdateMessageSubscriptionApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v4/monitor/update-message-subscription",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public UpdateMessageSubscriptionResponse send(
            Credential credential, UpdateMessageSubscriptionRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(UpdateMessageSubscriptionResponse.class);
    }

    public static class UpdateMessageSubscriptionRequest {
        /** 数据订阅ID */
        @JsonProperty("subscriptionID")
        private String subscriptionID;

        /** 资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 任务名称 */
        @JsonProperty("name")
        private String name;

        /**
         * 本参数表示订阅类型。取值范围：<br>
         * 1：监控数据。<br>
         * 2：告警数据。<br>
         * 4：事件数据。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("subscriptionType")
        private Integer subscriptionType;

        /**
         * 本参数表示订阅数据类型。取值范围：<br>
         * 1：具体实例。<br>
         * 2：全部资源。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("resourceType")
        private Integer resourceType;

        /** 如果 resourceType是1，为实例的ID列表，否则为空 */
        @JsonProperty("resources")
        private List<UpdateMessageSubscriptionResourcesRequest> resources;

        /** 数据订阅配置 */
        @JsonProperty("subscriptionConfig")
        private UpdateMessageSubscriptionSubscriptionConfigRequest subscriptionConfig;

        /**
         * 本参数表示通知方式。取值范围：<br>
         * 1：邮件。<br>
         * 2：短信。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("notificationMethod")
        private Integer notificationMethod;

        /** 异常通知的告警联系人组 */
        @JsonProperty("notificationGroupIDList")
        private List<String> notificationGroupIDList;

        public String getSubscriptionID() {
            return this.subscriptionID;
        }

        public void setSubscriptionID(String subscriptionID) {
            this.subscriptionID = subscriptionID;
        }

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Integer getSubscriptionType() {
            return this.subscriptionType;
        }

        public void setSubscriptionType(Integer subscriptionType) {
            this.subscriptionType = subscriptionType;
        }

        public Integer getResourceType() {
            return this.resourceType;
        }

        public void setResourceType(Integer resourceType) {
            this.resourceType = resourceType;
        }

        public List<UpdateMessageSubscriptionResourcesRequest> getResources() {
            return this.resources;
        }

        public void setResources(List<UpdateMessageSubscriptionResourcesRequest> resources) {
            this.resources = resources;
        }

        public UpdateMessageSubscriptionSubscriptionConfigRequest getSubscriptionConfig() {
            return this.subscriptionConfig;
        }

        public void setSubscriptionConfig(
                UpdateMessageSubscriptionSubscriptionConfigRequest subscriptionConfig) {
            this.subscriptionConfig = subscriptionConfig;
        }

        public Integer getNotificationMethod() {
            return this.notificationMethod;
        }

        public void setNotificationMethod(Integer notificationMethod) {
            this.notificationMethod = notificationMethod;
        }

        public List<String> getNotificationGroupIDList() {
            return this.notificationGroupIDList;
        }

        public void setNotificationGroupIDList(List<String> notificationGroupIDList) {
            this.notificationGroupIDList = notificationGroupIDList;
        }
    }

    public static class UpdateMessageSubscriptionResourcesRequest {
        /** 资源信息 */
        @JsonProperty("resource")
        private List<UpdateMessageSubscriptionResourcesResourceRequest> resource;

        public List<UpdateMessageSubscriptionResourcesResourceRequest> getResource() {
            return this.resource;
        }

        public void setResource(List<UpdateMessageSubscriptionResourcesResourceRequest> resource) {
            this.resource = resource;
        }
    }

    public static class UpdateMessageSubscriptionSubscriptionConfigRequest {
        /**
         * 本参数目标类型。取值范围：<br>
         * 1：kafka。<br>
         * 4：API。<br>
         * 5：remoteWrite。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("targetType")
        private Integer targetType;

        /** 开始时间 */
        @JsonProperty("startTime")
        private String startTime;

        /** 结束时间 */
        @JsonProperty("endTime")
        private String endTime;

        /** 目标地址 */
        @JsonProperty("targetAddress")
        private String targetAddress;

        /** 消息队列主题 */
        @JsonProperty("targetPath")
        private String targetPath;

        /** 用户名 */
        @JsonProperty("authUser")
        private String authUser;

        /** 密码 */
        @JsonProperty("authPassword")
        private String authPassword;

        public Integer getTargetType() {
            return this.targetType;
        }

        public void setTargetType(Integer targetType) {
            this.targetType = targetType;
        }

        public String getStartTime() {
            return this.startTime;
        }

        public void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        public String getEndTime() {
            return this.endTime;
        }

        public void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        public String getTargetAddress() {
            return this.targetAddress;
        }

        public void setTargetAddress(String targetAddress) {
            this.targetAddress = targetAddress;
        }

        public String getTargetPath() {
            return this.targetPath;
        }

        public void setTargetPath(String targetPath) {
            this.targetPath = targetPath;
        }

        public String getAuthUser() {
            return this.authUser;
        }

        public void setAuthUser(String authUser) {
            this.authUser = authUser;
        }

        public String getAuthPassword() {
            return this.authPassword;
        }

        public void setAuthPassword(String authPassword) {
            this.authPassword = authPassword;
        }
    }

    public static class UpdateMessageSubscriptionResourcesResourceRequest {
        /** 资源实例标签键 */
        @JsonProperty("name")
        private String name;

        /** 资源实例标签值 */
        @JsonProperty("value")
        private String value;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class UpdateMessageSubscriptionResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，适配中英文 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 失败时的错误描述，适配中英文 */
        @JsonProperty("description")
        private String description;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private UpdateMessageSubscriptionReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public UpdateMessageSubscriptionReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(UpdateMessageSubscriptionReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class UpdateMessageSubscriptionReturnObjResponse {
        /** 数据订阅ID */
        @JsonProperty("subscriptionID")
        private String subscriptionID;

        public String getSubscriptionID() {
            return this.subscriptionID;
        }

        public void setSubscriptionID(String subscriptionID) {
            this.subscriptionID = subscriptionID;
        }
    }
}
