package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 调用此接口可变更告警联系人所属的告警联系人组列表。 */
public class MonitorV41changeContactGroupsApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorV41changeContactGroupsApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v4.1/monitor/update-contact-groups",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public V41changeContactGroupsResponse send(
            Credential credential, V41changeContactGroupsRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(V41changeContactGroupsResponse.class);
    }

    public static class V41changeContactGroupsRequest {
        /** 告警联系人ID列表 */
        @JsonProperty("contactIDList")
        private List<String> contactIDList;

        /** 告警联系人组ID列表 */
        @JsonProperty("contactGroupIDList")
        private List<String> contactGroupIDList;

        public List<String> getContactIDList() {
            return this.contactIDList;
        }

        public void setContactIDList(List<String> contactIDList) {
            this.contactIDList = contactIDList;
        }

        public List<String> getContactGroupIDList() {
            return this.contactGroupIDList;
        }

        public void setContactGroupIDList(List<String> contactGroupIDList) {
            this.contactGroupIDList = contactGroupIDList;
        }
    }

    public static class V41changeContactGroupsResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，一般为中文描述 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 返回参数 */
        @JsonProperty("returnObj")
        private V41changeContactGroupsReturnObjResponse returnObj;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public V41changeContactGroupsReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(V41changeContactGroupsReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class V41changeContactGroupsReturnObjResponse {
        /** 告警联系人ID列表 */
        @JsonProperty("contactIDList")
        private String contactIDList;

        public String getContactIDList() {
            return this.contactIDList;
        }

        public void setContactIDList(String contactIDList) {
            this.contactIDList = contactIDList;
        }
    }
}
