package cn.ctyun.apis;

import cn.ctyun.sdk.*;
import cn.ctyun.sdk.Credential;
import cn.ctyun.sdk.CtyunClient;
import cn.ctyun.sdk.CtyunRequestException;

import org.junit.jupiter.api.Test;

import java.util.ArrayList;
import java.util.List;

class MonitorCreateAlarmTemplateApiTest {
    @Test
    void send() throws CtyunRequestException {
        CtyunClient ctyunClient = CtyunClient.defaultClient();
        Credential credential = new Credential("<YOUR_AK>", "<YOUR_SK>");
        // Credential credential = Credential.credentialFromEnv();
        Apis apis = new Apis("<YOUR_ENDPOINT>", ctyunClient);

        MonitorCreateAlarmTemplateApi.CreateAlarmTemplateRequest request =
                new MonitorCreateAlarmTemplateApi.CreateAlarmTemplateRequest();
        request.setRegionID("81f7728662dd11ec810800155d307d5b");
        request.setName("ctyun_alarm_template");
        request.setService("ecs");
        request.setDimension("ecs");
        request.setDesc("demo");
        MonitorCreateAlarmTemplateApi.CreateAlarmTemplateConditionsRequest request1 =
                new MonitorCreateAlarmTemplateApi.CreateAlarmTemplateConditionsRequest();
        request1.setEvaluationCount(2);
        request1.setMetric("cpu_util");
        request1.setFun("min");
        request1.setOperator("le");
        request1.setValue("80");
        request1.setPeriod("5m");
        request1.setUnit("KB/s");
        request1.setLevel(3);
        List<MonitorCreateAlarmTemplateApi.CreateAlarmTemplateConditionsRequest> request2 =
                new ArrayList<>();
        request2.add(request1);
        request.setConditions(request2);

        MonitorCreateAlarmTemplateApi.CreateAlarmTemplateResponse response =
                apis.monitorCreateAlarmTemplateApi.send(credential, request);
        System.out.println(response);
    }
}
