package cn.ctyun.apis;

import cn.ctyun.sdk.*;
import cn.ctyun.sdk.Credential;
import cn.ctyun.sdk.CtyunClient;
import cn.ctyun.sdk.CtyunRequestException;

import org.junit.jupiter.api.Test;

import java.util.ArrayList;
import java.util.List;

class MonitorCreateCustomItemApiTest {
    @Test
    void send() throws CtyunRequestException {
        CtyunClient ctyunClient = CtyunClient.defaultClient();
        Credential credential = new Credential("<YOUR_AK>", "<YOUR_SK>");
        // Credential credential = Credential.credentialFromEnv();
        Apis apis = new Apis("<YOUR_ENDPOINT>", ctyunClient);

        MonitorCreateCustomItemApi.CreateCustomItemRequest request =
                new MonitorCreateCustomItemApi.CreateCustomItemRequest();
        request.setRegionID("81f7728662dd11ec810800155d307d5b");
        request.setName("我的CPU使用率");
        request.setUnit("%");
        request.setInterval(60);
        MonitorCreateCustomItemApi.CreateCustomItemDimensionsRequest request1 =
                new MonitorCreateCustomItemApi.CreateCustomItemDimensionsRequest();
        request1.setName("维度名称，支持英文、下划线");
        request1.setDescription("维度描述，支持中文、英文、下划线");
        List<MonitorCreateCustomItemApi.CreateCustomItemDimensionsRequest> request2 =
                new ArrayList<>();
        request2.add(request1);
        request.setDimensions(request2);

        MonitorCreateCustomItemApi.CreateCustomItemResponse response =
                apis.monitorCreateCustomItemApi.send(credential, request);
        System.out.println(response);
    }
}
