package cn.ctyun.apis;

import cn.ctyun.sdk.*;
import cn.ctyun.sdk.Credential;
import cn.ctyun.sdk.CtyunClient;
import cn.ctyun.sdk.CtyunRequestException;

import org.junit.jupiter.api.Test;

import java.util.ArrayList;
import java.util.List;

class MonitorModifyInspectionItemApiTest {
    @Test
    void send() throws CtyunRequestException {
        CtyunClient ctyunClient = CtyunClient.defaultClient();
        Credential credential = new Credential("<YOUR_AK>", "<YOUR_SK>");
        // Credential credential = Credential.credentialFromEnv();
        Apis apis = new Apis("<YOUR_ENDPOINT>", ctyunClient);

        MonitorModifyInspectionItemApi.ModifyInspectionItemRequest request =
                new MonitorModifyInspectionItemApi.ModifyInspectionItemRequest();
        request.setInspectionItem(1);
        request.setLevel(2);
        MonitorModifyInspectionItemApi.ModifyInspectionItemInspectionRulesRequest request1 =
                new MonitorModifyInspectionItemApi.ModifyInspectionItemInspectionRulesRequest();
        request1.setMonitorItem("cpu_util");
        request1.setPeriod(3);
        request1.setMonitorValue(90D);
        List<MonitorModifyInspectionItemApi.ModifyInspectionItemInspectionRulesRequest> request2 =
                new ArrayList<>();
        request2.add(request1);
        request.setInspectionRules(request2);

        MonitorModifyInspectionItemApi.ModifyInspectionItemResponse response =
                apis.monitorModifyInspectionItemApi.send(credential, request);
        System.out.println(response);
    }
}
