package cn.ctyun.apis;

import cn.ctyun.sdk.*;
import cn.ctyun.sdk.Credential;
import cn.ctyun.sdk.CtyunClient;
import cn.ctyun.sdk.CtyunRequestException;

import org.junit.jupiter.api.Test;

import java.util.ArrayList;
import java.util.List;

class MonitorPutAlarmTemplateApiTest {
    @Test
    void send() throws CtyunRequestException {
        CtyunClient ctyunClient = CtyunClient.defaultClient();
        Credential credential = new Credential("<YOUR_AK>", "<YOUR_SK>");
        // Credential credential = Credential.credentialFromEnv();
        Apis apis = new Apis("<YOUR_ENDPOINT>", ctyunClient);

        MonitorPutAlarmTemplateApi.PutAlarmTemplateRequest request =
                new MonitorPutAlarmTemplateApi.PutAlarmTemplateRequest();
        request.setTemplateID("312b56b4-3e43-11ed-8ef2-005056898fe0");
        request.setRegionID("81f7728662dd11ec810800155d307d5b");
        request.setName("ctyun_alarm_template");
        request.setDesc("demo");
        request.setService("ecs");
        request.setDimension("ecs");
        MonitorPutAlarmTemplateApi.PutAlarmTemplateConditionsRequest request1 =
                new MonitorPutAlarmTemplateApi.PutAlarmTemplateConditionsRequest();
        request1.setEvaluationCount(2);
        request1.setMetric("cpu_util");
        request1.setFun("min");
        request1.setOperator("le");
        request1.setValue("80");
        request1.setPeriod("5m");
        request1.setUnit("KB/s");
        request1.setLevel(3);
        List<MonitorPutAlarmTemplateApi.PutAlarmTemplateConditionsRequest> request2 =
                new ArrayList<>();
        request2.add(request1);
        request.setConditions(request2);

        MonitorPutAlarmTemplateApi.PutAlarmTemplateResponse response =
                apis.monitorPutAlarmTemplateApi.send(credential, request);
        System.out.println(response);
    }
}
