package cn.ctyun.apis;

import cn.ctyun.sdk.*;
import cn.ctyun.sdk.Credential;
import cn.ctyun.sdk.CtyunClient;
import cn.ctyun.sdk.CtyunRequestException;

import org.junit.jupiter.api.Test;

class MonitorQueryCustomEventsApiTest {
    @Test
    void send() throws CtyunRequestException {
        CtyunClient ctyunClient = CtyunClient.defaultClient();
        Credential credential = new Credential("<YOUR_AK>", "<YOUR_SK>");
        // Credential credential = Credential.credentialFromEnv();
        Apis apis = new Apis("<YOUR_ENDPOINT>", ctyunClient);

        MonitorQueryCustomEventsApi.QueryCustomEventsRequest request =
                new MonitorQueryCustomEventsApi.QueryCustomEventsRequest();
        request.setRegionID("81f7728662dd11ec810800155d307d5b");
        request.setCustomEventID("ITEM793d5923652be6ce202306291409");
        request.setName("我的CPU使用率");
        request.setPageNo(1);
        request.setPageSize(10);

        MonitorQueryCustomEventsApi.QueryCustomEventsResponse response =
                apis.monitorQueryCustomEventsApi.send(credential, request);
        System.out.println(response);
    }
}
