package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 调用此接口可变更告警联系组内的告警联系人列表。 */
public class MonitorChangeGroupContactsApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorChangeGroupContactsApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v4/monitor/update-group-contacts",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ChangeGroupContactsResponse send(
            Credential credential, ChangeGroupContactsRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ChangeGroupContactsResponse.class);
    }

    public static class ChangeGroupContactsRequest {
        /** 组ID */
        @JsonProperty("contactGroupID")
        private String contactGroupID;

        /**
         * 本参数表示变更类型。取值范围：<br>
         * add：新增。<br>
         * del：删除。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("actionType")
        private String actionType;

        /** 告警联系人ID列表 */
        @JsonProperty("contactIDList")
        private List<String> contactIDList;

        public String getContactGroupID() {
            return this.contactGroupID;
        }

        public void setContactGroupID(String contactGroupID) {
            this.contactGroupID = contactGroupID;
        }

        public String getActionType() {
            return this.actionType;
        }

        public void setActionType(String actionType) {
            this.actionType = actionType;
        }

        public List<String> getContactIDList() {
            return this.contactIDList;
        }

        public void setContactIDList(List<String> contactIDList) {
            this.contactIDList = contactIDList;
        }
    }

    public static class ChangeGroupContactsResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，一般为中文描述 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 返回参数 */
        @JsonProperty("returnObj")
        private ChangeGroupContactsReturnObjResponse returnObj;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public ChangeGroupContactsReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(ChangeGroupContactsReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class ChangeGroupContactsReturnObjResponse {
        /** 告警联系人组ID */
        @JsonProperty("contactGroupID")
        private String contactGroupID;

        public String getContactGroupID() {
            return this.contactGroupID;
        }

        public void setContactGroupID(String contactGroupID) {
            this.contactGroupID = contactGroupID;
        }
    }
}
