package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 调用此接口可创建告警模板。 */
public class MonitorCreateAlarmTemplateApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorCreateAlarmTemplateApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v4/monitor/create-alarm-template",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public CreateAlarmTemplateResponse send(
            Credential credential, CreateAlarmTemplateRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(CreateAlarmTemplateResponse.class);
    }

    public static class CreateAlarmTemplateRequest {
        /** ctyun资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 告警模板名称 */
        @JsonProperty("name")
        private String name;

        /**
         * 本参数表示服务。取值范围：<br>
         * ecs：云主机。<br>
         * evs：云硬盘。<br>
         * pms：物理机。<br>
         * ...<br>
         * 详见"[云监控：查询服务维度及监控项](https://www.ctyun.cn/document/10032263/10747790)"接口返回。
         */
        @JsonProperty("service")
        private String service;

        /**
         * 本参数表示告警维度。取值范围：<br>
         * ecs：云主机。<br>
         * disk：磁盘。<br>
         * pms：物理机。<br>
         * ...<br>
         * 详见"[云监控：查询服务维度及监控项](https://www.ctyun.cn/document/10032263/10747790)"接口返回。
         */
        @JsonProperty("dimension")
        private String dimension;

        /** 告警模板描述 */
        @JsonProperty("desc")
        private String desc;

        /** 告警规则 */
        @JsonProperty("conditions")
        private List<CreateAlarmTemplateConditionsRequest> conditions;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getService() {
            return this.service;
        }

        public void setService(String service) {
            this.service = service;
        }

        public String getDimension() {
            return this.dimension;
        }

        public void setDimension(String dimension) {
            this.dimension = dimension;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public List<CreateAlarmTemplateConditionsRequest> getConditions() {
            return this.conditions;
        }

        public void setConditions(List<CreateAlarmTemplateConditionsRequest> conditions) {
            this.conditions = conditions;
        }
    }

    public static class CreateAlarmTemplateConditionsRequest {
        /** 持续次数，当规则执行结果持续多久符合条件时报警（防抖），默认值：2 */
        @JsonProperty("evaluationCount")
        private Integer evaluationCount;

        /** 监控指标，说明有condition参数时，metric是必填项 */
        @JsonProperty("metric")
        private String metric;

        /**
         * 本参数表示采用算法。默认值：min。取值范围：<br>
         * last：原始值。<br>
         * avg：平均值。<br>
         * max：最大值。<br>
         * min：最小值。<br>
         * sum：总和。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("fun")
        private String fun;

        /**
         * 本参数表示比较符。默认值：le。取值范围：<br>
         * eq：等于。<br>
         * gt：大于。<br>
         * ge：大于等于。<br>
         * lt：小于。<br>
         * le：小于等于。<br>
         * ne：不等于。<br>
         * rg：环比上升。<br>
         * cf：环比下降。<br>
         * rc：环比变化。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("operator")
        private String operator;

        /**
         * 告警阈值，整数型或小数点型字符串， 默认值：80。 <br>
         * 如果是小数点型字符串，小数点位数不能超过2位。
         */
        @JsonProperty("value")
        private String value;

        /**
         * 本参数表示算法统计周期。默认值：5m。<br>
         * 参数fun为last时不可传。<br>
         * 参数fun为avg、max、min、sum均需填此参数。<br>
         * 本参数格式为“数字+单位”。单位取值范围：<br>
         * m：分钟。<br>
         * h：小时。<br>
         * d：天。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("period")
        private String period;

        /** 本参数表示单位. 默认值：空字符。 */
        @JsonProperty("unit")
        private String unit;

        /**
         * 本参数表示告警等级。默认值：3。 取值范围：<br>
         * 1：紧急。<br>
         * 2：警示。<br>
         * 3：普通。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("level")
        private Integer level;

        public Integer getEvaluationCount() {
            return this.evaluationCount;
        }

        public void setEvaluationCount(Integer evaluationCount) {
            this.evaluationCount = evaluationCount;
        }

        public String getMetric() {
            return this.metric;
        }

        public void setMetric(String metric) {
            this.metric = metric;
        }

        public String getFun() {
            return this.fun;
        }

        public void setFun(String fun) {
            this.fun = fun;
        }

        public String getOperator() {
            return this.operator;
        }

        public void setOperator(String operator) {
            this.operator = operator;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getPeriod() {
            return this.period;
        }

        public void setPeriod(String period) {
            this.period = period;
        }

        public String getUnit() {
            return this.unit;
        }

        public void setUnit(String unit) {
            this.unit = unit;
        }

        public Integer getLevel() {
            return this.level;
        }

        public void setLevel(Integer level) {
            this.level = level;
        }
    }

    public static class CreateAlarmTemplateResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，一般为中文描述 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        /** 返回参数，参考returnObj对象结构 */
        @JsonProperty("returnObj")
        private CreateAlarmTemplateReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public CreateAlarmTemplateReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(CreateAlarmTemplateReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class CreateAlarmTemplateReturnObjResponse {
        /** 告警模板ID */
        @JsonProperty("templateID")
        private String templateID;

        public String getTemplateID() {
            return this.templateID;
        }

        public void setTemplateID(String templateID) {
            this.templateID = templateID;
        }
    }
}
