package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 调用此接口可创建自定义事件。 */
public class MonitorCreateCustomEventApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorCreateCustomEventApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v4/monitor/create-custom-event",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public CreateCustomEventResponse send(Credential credential, CreateCustomEventRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(CreateCustomEventResponse.class);
    }

    public static class CreateCustomEventRequest {
        /** 资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 事件名称，必须4-20个字符，支持中英文、数字、下划线，且不能以数字开头。同一用户在同一资源池下不能重复 */
        @JsonProperty("name")
        private String name;

        /** 事件描述，最多50个字符 */
        @JsonProperty("description")
        private String description;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }

    public static class CreateCustomEventResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，一般为中文描述 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 返回参数，参考returnObj对象结构 */
        @JsonProperty("returnObj")
        private CreateCustomEventReturnObjResponse returnObj;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public CreateCustomEventReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(CreateCustomEventReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class CreateCustomEventReturnObjResponse {
        /** 自定义事件ID */
        @JsonProperty("customEventID")
        private String customEventID;

        public String getCustomEventID() {
            return this.customEventID;
        }

        public void setCustomEventID(String customEventID) {
            this.customEventID = customEventID;
        }
    }
}
