package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 调用此接口可创建数据导出任务。 */
public class MonitorCreateDataExportTaskApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorCreateDataExportTaskApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v4/monitor/task-center/create-task",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public CreateDataExportTaskResponse send(
            Credential credential, CreateDataExportTaskRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(CreateDataExportTaskResponse.class);
    }

    public static class CreateDataExportTaskRequest {
        /** 资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 任务的具体参数 */
        @JsonProperty("task")
        private CreateDataExportTaskTaskRequest task;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public CreateDataExportTaskTaskRequest getTask() {
            return this.task;
        }

        public void setTask(CreateDataExportTaskTaskRequest task) {
            this.task = task;
        }
    }

    public static class CreateDataExportTaskTaskRequest {
        /** 任务名称，必须4-20个字符，支持中英文、数字、下划线 */
        @JsonProperty("name")
        private String name;

        /** 任务描述，最多50个字符 */
        @JsonProperty("description")
        private String description;

        /**
         * 云监控服务。取值范围： <br>
         * ecs：云主机。 <br>
         * evs：云硬盘。 <br>
         * pms：物理机。 <br>
         * ... <br>
         * 具体服务参见[云监控：查询服务维度及监控项](https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=22&api=15746&data=90&isNormal=1&vid=84)
         */
        @JsonProperty("service")
        private String service;

        /**
         * 云监控维度。取值范围： <br>
         * ecs：云主机。 <br>
         * disk：云硬盘。 <br>
         * pms：物理机。 <br>
         * ... <br>
         * 具体服务参见[云监控：查询服务维度及监控项](https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=22&api=15746&data=90&isNormal=1&vid=84)
         */
        @JsonProperty("dimension")
        private String dimension;

        /** 查询设备标签列表，用于定位目标设备，多标签查询取交集 */
        @JsonProperty("dimensions")
        private List<CreateDataExportTaskTaskDimensionsRequest> dimensions;

        /**
         * 待查的监控项名称，具体设备对应监控项参见[云监控：查询服务维度及监控项](https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=22&api=15746&data=90&isNormal=1&vid=84)
         */
        @JsonProperty("itemNameList")
        private List<String> itemNameList;

        /**
         * 本参数表示数据聚合类型。取值范围：<br>
         * raw：原始值。<br>
         * avg：平均值。<br>
         * max：最大值。<br>
         * min：最小值。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("aggregateType")
        private List<String> aggregateType;

        /** 数据起始时间，秒级 */
        @JsonProperty("startTime")
        private Integer startTime;

        /** 数据截止时间，秒级 */
        @JsonProperty("endTime")
        private Integer endTime;

        /** 聚合周期（除raw外其他聚合类型必传），单位：秒 */
        @JsonProperty("period")
        private Integer period;

        /**
         * 本参数表示报表模板。默认值为0。取值范围：<br>
         * 0：默认报表模板。<br>
         * 1：基础报表模板。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("reportTemplate")
        private Integer reportTemplate;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getService() {
            return this.service;
        }

        public void setService(String service) {
            this.service = service;
        }

        public String getDimension() {
            return this.dimension;
        }

        public void setDimension(String dimension) {
            this.dimension = dimension;
        }

        public List<CreateDataExportTaskTaskDimensionsRequest> getDimensions() {
            return this.dimensions;
        }

        public void setDimensions(List<CreateDataExportTaskTaskDimensionsRequest> dimensions) {
            this.dimensions = dimensions;
        }

        public List<String> getItemNameList() {
            return this.itemNameList;
        }

        public void setItemNameList(List<String> itemNameList) {
            this.itemNameList = itemNameList;
        }

        public List<String> getAggregateType() {
            return this.aggregateType;
        }

        public void setAggregateType(List<String> aggregateType) {
            this.aggregateType = aggregateType;
        }

        public Integer getStartTime() {
            return this.startTime;
        }

        public void setStartTime(Integer startTime) {
            this.startTime = startTime;
        }

        public Integer getEndTime() {
            return this.endTime;
        }

        public void setEndTime(Integer endTime) {
            this.endTime = endTime;
        }

        public Integer getPeriod() {
            return this.period;
        }

        public void setPeriod(Integer period) {
            this.period = period;
        }

        public Integer getReportTemplate() {
            return this.reportTemplate;
        }

        public void setReportTemplate(Integer reportTemplate) {
            this.reportTemplate = reportTemplate;
        }
    }

    public static class CreateDataExportTaskTaskDimensionsRequest {
        /** 设备标签键 */
        @JsonProperty("name")
        private String name;

        /** 设备标签键所对应的值 */
        @JsonProperty("value")
        private List<String> value;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<String> getValue() {
            return this.value;
        }

        public void setValue(List<String> value) {
            this.value = value;
        }
    }

    public static class CreateDataExportTaskResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，一般为中文描述 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        /** 返回参数，参考returnObj对象结构 */
        @JsonProperty("returnObj")
        private CreateDataExportTaskReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public CreateDataExportTaskReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(CreateDataExportTaskReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class CreateDataExportTaskReturnObjResponse {
        /** 数据导出任务ID */
        @JsonProperty("taskID")
        private String taskID;

        public String getTaskID() {
            return this.taskID;
        }

        public void setTaskID(String taskID) {
            this.taskID = taskID;
        }
    }
}
