package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 调用此接口可创建拨测任务。 */
public class MonitorCreateInstantDetectionTaskApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorCreateInstantDetectionTaskApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v4/monitor/create-instant-detection-task",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public CreateInstantDetectionTaskResponse send(
            Credential credential, CreateInstantDetectionTaskRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(CreateInstantDetectionTaskResponse.class);
    }

    public static class CreateInstantDetectionTaskRequest {
        /** 目标拨测地 */
        @JsonProperty("address")
        private String address;

        /** 拨测点列表 */
        @JsonProperty("pointID")
        private List<String> pointID;

        /**
         * 本参数表示拨测任务类型。取值范围：<br>
         * http：http探测。<br>
         * ping：ping探测。<br>
         * mtr：mtr探测。<br>
         * traceroute：traceroute探测。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("type")
        private String type;

        public String getAddress() {
            return this.address;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public List<String> getPointID() {
            return this.pointID;
        }

        public void setPointID(List<String> pointID) {
            this.pointID = pointID;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }

    public static class CreateInstantDetectionTaskResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，一般为中文描述 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 返回参数，参考returnObj对象结构 */
        @JsonProperty("returnObj")
        private CreateInstantDetectionTaskReturnObjResponse returnObj;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public CreateInstantDetectionTaskReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(CreateInstantDetectionTaskReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class CreateInstantDetectionTaskReturnObjResponse {
        /** 拨测任务ID */
        @JsonProperty("taskID")
        private String taskID;

        public String getTaskID() {
            return this.taskID;
        }

        public void setTaskID(String taskID) {
            this.taskID = taskID;
        }
    }
}
