package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 调用此接口可创建数据订阅。 */
public class MonitorCreateMessageSubscriptionApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorCreateMessageSubscriptionApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v4/monitor/create-message-subscription",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public CreateMessageSubscriptionResponse send(
            Credential credential, CreateMessageSubscriptionRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(CreateMessageSubscriptionResponse.class);
    }

    public static class CreateMessageSubscriptionRequest {
        /** 资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 任务名称 */
        @JsonProperty("name")
        private String name;

        /**
         * 本参数表示订阅类型。取值范围：<br>
         * 1：监控数据。<br>
         * 2：告警数据。<br>
         * 4：事件数据。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("subscriptionType")
        private Integer subscriptionType;

        /**
         * 云监控服务。取值范围： <br>
         * ecs：云主机。 <br>
         * evs：云硬盘。 <br>
         * pms：物理机。 <br>
         * ... <br>
         * 具体服务参见[云监控：查询服务维度及监控项](https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=22&api=15746&data=90&isNormal=1&vid=84)
         */
        @JsonProperty("service")
        private String service;

        /**
         * 云监控维度。取值范围： <br>
         * ecs：云主机。 <br>
         * disk：云硬盘。 <br>
         * pms：物理机。 <br>
         * ... <br>
         * 具体服务参见[云监控：查询服务维度及监控项](https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=22&api=15746&data=90&isNormal=1&vid=84)
         */
        @JsonProperty("dimension")
        private String dimension;

        /**
         * 本参数表示订阅数据类型。取值范围：<br>
         * 1：具体实例。<br>
         * 2：全部资源。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("resourceType")
        private Integer resourceType;

        /** 如果 resourceType是1，为实例的ID列表，否则为空 */
        @JsonProperty("resources")
        private List<CreateMessageSubscriptionResourcesRequest> resources;

        /** 数据订阅配置 */
        @JsonProperty("subscriptionConfig")
        private CreateMessageSubscriptionSubscriptionConfigRequest subscriptionConfig;

        /**
         * 本参数表示通知方式。取值范围：<br>
         * 1：邮件。<br>
         * 2：短信。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("notificationMethod")
        private Integer notificationMethod;

        /** 异常通知的告警联系人组 */
        @JsonProperty("notificationGroupIDList")
        private List<String> notificationGroupIDList;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Integer getSubscriptionType() {
            return this.subscriptionType;
        }

        public void setSubscriptionType(Integer subscriptionType) {
            this.subscriptionType = subscriptionType;
        }

        public String getService() {
            return this.service;
        }

        public void setService(String service) {
            this.service = service;
        }

        public String getDimension() {
            return this.dimension;
        }

        public void setDimension(String dimension) {
            this.dimension = dimension;
        }

        public Integer getResourceType() {
            return this.resourceType;
        }

        public void setResourceType(Integer resourceType) {
            this.resourceType = resourceType;
        }

        public List<CreateMessageSubscriptionResourcesRequest> getResources() {
            return this.resources;
        }

        public void setResources(List<CreateMessageSubscriptionResourcesRequest> resources) {
            this.resources = resources;
        }

        public CreateMessageSubscriptionSubscriptionConfigRequest getSubscriptionConfig() {
            return this.subscriptionConfig;
        }

        public void setSubscriptionConfig(
                CreateMessageSubscriptionSubscriptionConfigRequest subscriptionConfig) {
            this.subscriptionConfig = subscriptionConfig;
        }

        public Integer getNotificationMethod() {
            return this.notificationMethod;
        }

        public void setNotificationMethod(Integer notificationMethod) {
            this.notificationMethod = notificationMethod;
        }

        public List<String> getNotificationGroupIDList() {
            return this.notificationGroupIDList;
        }

        public void setNotificationGroupIDList(List<String> notificationGroupIDList) {
            this.notificationGroupIDList = notificationGroupIDList;
        }
    }

    public static class CreateMessageSubscriptionResourcesRequest {
        /** 资源信息 */
        @JsonProperty("resource")
        private List<CreateMessageSubscriptionResourcesResourceRequest> resource;

        public List<CreateMessageSubscriptionResourcesResourceRequest> getResource() {
            return this.resource;
        }

        public void setResource(List<CreateMessageSubscriptionResourcesResourceRequest> resource) {
            this.resource = resource;
        }
    }

    public static class CreateMessageSubscriptionSubscriptionConfigRequest {
        /**
         * 本参数目标类型。取值范围：<br>
         * 1：kafka。<br>
         * 4：API。<br>
         * 5：remoteWrite。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("targetType")
        private Integer targetType;

        /** 开始时间 */
        @JsonProperty("startTime")
        private String startTime;

        /** 结束时间 */
        @JsonProperty("endTime")
        private String endTime;

        /** 目标地址 */
        @JsonProperty("targetAddress")
        private String targetAddress;

        /** 消息队列主题 */
        @JsonProperty("targetPath")
        private String targetPath;

        /** 用户名 */
        @JsonProperty("authUser")
        private String authUser;

        /** 密码 */
        @JsonProperty("authPassword")
        private String authPassword;

        public Integer getTargetType() {
            return this.targetType;
        }

        public void setTargetType(Integer targetType) {
            this.targetType = targetType;
        }

        public String getStartTime() {
            return this.startTime;
        }

        public void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        public String getEndTime() {
            return this.endTime;
        }

        public void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        public String getTargetAddress() {
            return this.targetAddress;
        }

        public void setTargetAddress(String targetAddress) {
            this.targetAddress = targetAddress;
        }

        public String getTargetPath() {
            return this.targetPath;
        }

        public void setTargetPath(String targetPath) {
            this.targetPath = targetPath;
        }

        public String getAuthUser() {
            return this.authUser;
        }

        public void setAuthUser(String authUser) {
            this.authUser = authUser;
        }

        public String getAuthPassword() {
            return this.authPassword;
        }

        public void setAuthPassword(String authPassword) {
            this.authPassword = authPassword;
        }
    }

    public static class CreateMessageSubscriptionResourcesResourceRequest {
        /** 资源实例标签键 */
        @JsonProperty("name")
        private String name;

        /** 资源实例标签值 */
        @JsonProperty("value")
        private String value;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class CreateMessageSubscriptionResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，适配中英文 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 失败时的错误描述，适配中英文 */
        @JsonProperty("description")
        private String description;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private CreateMessageSubscriptionReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public CreateMessageSubscriptionReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(CreateMessageSubscriptionReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class CreateMessageSubscriptionReturnObjResponse {
        /** 数据订阅ID */
        @JsonProperty("subscriptionID")
        private String subscriptionID;

        public String getSubscriptionID() {
            return this.subscriptionID;
        }

        public void setSubscriptionID(String subscriptionID) {
            this.subscriptionID = subscriptionID;
        }
    }
}
