package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 为已存在的监控看板创建视图。 */
public class MonitorCreateViewOfMonitorBoardApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorCreateViewOfMonitorBoardApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v4/monitor/monitor-board/create-view",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public CreateViewOfMonitorBoardResponse send(
            Credential credential, CreateViewOfMonitorBoardRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(CreateViewOfMonitorBoardResponse.class);
    }

    public static class CreateViewOfMonitorBoardRequest {
        /** 资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 监控看板ID */
        @JsonProperty("boardID")
        private String boardID;

        /** 监控视图 */
        @JsonProperty("views")
        private List<CreateViewOfMonitorBoardViewsRequest> views;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getBoardID() {
            return this.boardID;
        }

        public void setBoardID(String boardID) {
            this.boardID = boardID;
        }

        public List<CreateViewOfMonitorBoardViewsRequest> getViews() {
            return this.views;
        }

        public void setViews(List<CreateViewOfMonitorBoardViewsRequest> views) {
            this.views = views;
        }
    }

    public static class CreateViewOfMonitorBoardViewsRequest {
        /** 监控视图名称, 同看板下的视图名称不可重复 */
        @JsonProperty("name")
        private String name;

        /**
         * 本参数表示云监控服务。取值范围：<br>
         * ecs：云主机。<br>
         * ...<br>
         * 具体服务参见[云监控：查询服务维度及监控项](https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=22&api=15746&data=90&isNormal=1&vid=84)
         */
        @JsonProperty("service")
        private String service;

        /**
         * 本参数表示云监控维度。取值范围：<br>
         * ecs：云主机。<br>
         * ...<br>
         * 具体服务参见[云监控：查询服务维度及监控项](https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=22&api=15746&data=90&isNormal=1&vid=84)
         */
        @JsonProperty("dimension")
        private String dimension;

        /**
         * 视图类型。取值范围：<br>
         * timeSeries：折线图。<br>
         * gauge：仪表盘。<br>
         * barChart：柱状图。<br>
         * table：表格。<br>
         * pieChart：饼状图。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("viewType")
        private String viewType;

        /** 视图排序次数。默认值为0。 */
        @JsonProperty("orderIndex")
        private Integer orderIndex;

        /** 监控指标，指标项最多支持20个， 当viewType为gauge和pieChart时，仅支持单监控指标 */
        @JsonProperty("itemNameList")
        private List<String> itemNameList;

        /**
         * 同比环比比较时间配置，格式为“数字+单位”，单位为空时默认为秒。<br>
         * 当前只支持1d和7d。<br>
         * 单位取值范围：<br>
         * m：分钟。<br>
         * h：小时。<br>
         * d：天。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("compares")
        private List<String> compares;

        /** 监控资源实例，监控对象最多支持20个， 当viewType为gauge时，仅支持单资源实例 */
        @JsonProperty("resources")
        private List<CreateViewOfMonitorBoardViewsResourcesRequest> resources;

        /** 仪表盘配置，仅当viewType为gauge时生效 */
        @JsonProperty("gaugePattern")
        private CreateViewOfMonitorBoardViewsGaugePatternRequest gaugePattern;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getService() {
            return this.service;
        }

        public void setService(String service) {
            this.service = service;
        }

        public String getDimension() {
            return this.dimension;
        }

        public void setDimension(String dimension) {
            this.dimension = dimension;
        }

        public String getViewType() {
            return this.viewType;
        }

        public void setViewType(String viewType) {
            this.viewType = viewType;
        }

        public Integer getOrderIndex() {
            return this.orderIndex;
        }

        public void setOrderIndex(Integer orderIndex) {
            this.orderIndex = orderIndex;
        }

        public List<String> getItemNameList() {
            return this.itemNameList;
        }

        public void setItemNameList(List<String> itemNameList) {
            this.itemNameList = itemNameList;
        }

        public List<String> getCompares() {
            return this.compares;
        }

        public void setCompares(List<String> compares) {
            this.compares = compares;
        }

        public List<CreateViewOfMonitorBoardViewsResourcesRequest> getResources() {
            return this.resources;
        }

        public void setResources(List<CreateViewOfMonitorBoardViewsResourcesRequest> resources) {
            this.resources = resources;
        }

        public CreateViewOfMonitorBoardViewsGaugePatternRequest getGaugePattern() {
            return this.gaugePattern;
        }

        public void setGaugePattern(CreateViewOfMonitorBoardViewsGaugePatternRequest gaugePattern) {
            this.gaugePattern = gaugePattern;
        }
    }

    public static class CreateViewOfMonitorBoardViewsResourcesRequest {
        /** 资源 */
        @JsonProperty("resource")
        private List<CreateViewOfMonitorBoardViewsResourcesResourceRequest> resource;

        public List<CreateViewOfMonitorBoardViewsResourcesResourceRequest> getResource() {
            return this.resource;
        }

        public void setResource(
                List<CreateViewOfMonitorBoardViewsResourcesResourceRequest> resource) {
            this.resource = resource;
        }
    }

    public static class CreateViewOfMonitorBoardViewsGaugePatternRequest {
        /** 仪表盘最小值。默认值为0 */
        @JsonProperty("minVal")
        private Integer minVal;

        /** 仪表盘最大值。默认值为100 */
        @JsonProperty("maxVal")
        private Integer maxVal;

        /** 仪表盘中间分段取值，长度必须为2。默认值为[30,80] */
        @JsonProperty("threshold")
        private List<Integer> threshold;

        public Integer getMinVal() {
            return this.minVal;
        }

        public void setMinVal(Integer minVal) {
            this.minVal = minVal;
        }

        public Integer getMaxVal() {
            return this.maxVal;
        }

        public void setMaxVal(Integer maxVal) {
            this.maxVal = maxVal;
        }

        public List<Integer> getThreshold() {
            return this.threshold;
        }

        public void setThreshold(List<Integer> threshold) {
            this.threshold = threshold;
        }
    }

    public static class CreateViewOfMonitorBoardViewsResourcesResourceRequest {
        /** 资源实例标签键 */
        @JsonProperty("key")
        private String key;

        /** 资源实例标签值 */
        @JsonProperty("value")
        private String value;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class CreateViewOfMonitorBoardResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，适配中英文 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 失败时的错误描述，适配中英文 */
        @JsonProperty("description")
        private String description;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private CreateViewOfMonitorBoardReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public CreateViewOfMonitorBoardReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(CreateViewOfMonitorBoardReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class CreateViewOfMonitorBoardReturnObjResponse {
        /** 视图ID */
        @JsonProperty("viewIDs")
        private List<String> viewIDs;

        public List<String> getViewIDs() {
            return this.viewIDs;
        }

        public void setViewIDs(List<String> viewIDs) {
            this.viewIDs = viewIDs;
        }
    }
}
