package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 调用此接口可查看告警模板的配置详情。 */
public class MonitorDescribeAlarmTemplateApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorDescribeAlarmTemplateApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v4/monitor/describe-alarm-template",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public DescribeAlarmTemplateResponse send(
            Credential credential, DescribeAlarmTemplateRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionID != null) {
            ctReq.addParam("regionID", request.regionID);
            request.regionID = null;
        }
        if (request.templateID != null) {
            ctReq.addParam("templateID", request.templateID);
            request.templateID = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(DescribeAlarmTemplateResponse.class);
    }

    public static class DescribeAlarmTemplateRequest {
        /** ctyun资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 告警模板ID */
        @JsonProperty("templateID")
        private String templateID;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getTemplateID() {
            return this.templateID;
        }

        public void setTemplateID(String templateID) {
            this.templateID = templateID;
        }
    }

    public static class DescribeAlarmTemplateResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，一般为中文描述 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        /** 返回参数 */
        @JsonProperty("returnObj")
        private DescribeAlarmTemplateReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public DescribeAlarmTemplateReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(DescribeAlarmTemplateReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class DescribeAlarmTemplateReturnObjResponse {
        /** 告警模板ID */
        @JsonProperty("templateID")
        private String templateID;

        /** 告警模板名称 */
        @JsonProperty("name")
        private String name;

        /** 服务 */
        @JsonProperty("service")
        private String service;

        /** 维度 */
        @JsonProperty("dimension")
        private String dimension;

        /** 告警模板描述 */
        @JsonProperty("desc")
        private String desc;

        /** 告警规则 */
        @JsonProperty("conditions")
        private List<DescribeAlarmTemplateReturnObjConditionsResponse> conditions;

        /** 创建时间，时间戳，精确到毫秒 */
        @JsonProperty("createTime")
        private Integer createTime;

        /** 最近更新时间, 时间戳，精确到毫秒 */
        @JsonProperty("updateTime")
        private Integer updateTime;

        public String getTemplateID() {
            return this.templateID;
        }

        public void setTemplateID(String templateID) {
            this.templateID = templateID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getService() {
            return this.service;
        }

        public void setService(String service) {
            this.service = service;
        }

        public String getDimension() {
            return this.dimension;
        }

        public void setDimension(String dimension) {
            this.dimension = dimension;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public List<DescribeAlarmTemplateReturnObjConditionsResponse> getConditions() {
            return this.conditions;
        }

        public void setConditions(
                List<DescribeAlarmTemplateReturnObjConditionsResponse> conditions) {
            this.conditions = conditions;
        }

        public Integer getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(Integer createTime) {
            this.createTime = createTime;
        }

        public Integer getUpdateTime() {
            return this.updateTime;
        }

        public void setUpdateTime(Integer updateTime) {
            this.updateTime = updateTime;
        }
    }

    public static class DescribeAlarmTemplateReturnObjConditionsResponse {
        /** 持续次数，当规则执行结果持续多久符合条件时报警（防抖） */
        @JsonProperty("evaluationCount")
        private Integer evaluationCount;

        /** 监控指标 */
        @JsonProperty("metric")
        private String metric;

        /** 监控指标中文描述 */
        @JsonProperty("metricCnName")
        private String metricCnName;

        /**
         * 本参数表示告警采用算法。取值范围：<br>
         * last：原始值算法。<br>
         * avg：平均值算法。<br>
         * max：最大值算法。<br>
         * min：最小值算法。<br>
         * sum：求和算法。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("fun")
        private String fun;

        /**
         * 本参数表示比较符。取值范围：<br>
         * eq：等于。<br>
         * gt：大于。<br>
         * ge：大于等于。<br>
         * lt：小于。<br>
         * le：小于等于。<br>
         * rg：环比上升。<br>
         * cf：环比下降。<br>
         * rc：环比变化。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("operator")
        private String operator;

        /** 告警阈值 */
        @JsonProperty("value")
        private String value;

        /**
         * 本参数表示算法统计周期。<br>
         * 参数fun为last时无效。<br>
         * 本参数格式为“数字+单位”。单位取值范围：<br>
         * m：分钟。<br>
         * h：小时。<br>
         * d：天。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("period")
        private String period;

        /** 单位 */
        @JsonProperty("unit")
        private String unit;

        /**
         * 本参数表示告警等级。取值范围：<br>
         * 1：紧急。<br>
         * 2：警示。<br>
         * 3：普通。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("level")
        private Integer level;

        public Integer getEvaluationCount() {
            return this.evaluationCount;
        }

        public void setEvaluationCount(Integer evaluationCount) {
            this.evaluationCount = evaluationCount;
        }

        public String getMetric() {
            return this.metric;
        }

        public void setMetric(String metric) {
            this.metric = metric;
        }

        public String getMetricCnName() {
            return this.metricCnName;
        }

        public void setMetricCnName(String metricCnName) {
            this.metricCnName = metricCnName;
        }

        public String getFun() {
            return this.fun;
        }

        public void setFun(String fun) {
            this.fun = fun;
        }

        public String getOperator() {
            return this.operator;
        }

        public void setOperator(String operator) {
            this.operator = operator;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getPeriod() {
            return this.period;
        }

        public void setPeriod(String period) {
            this.period = period;
        }

        public String getUnit() {
            return this.unit;
        }

        public void setUnit(String unit) {
            this.unit = unit;
        }

        public Integer getLevel() {
            return this.level;
        }

        public void setLevel(Integer level) {
            this.level = level;
        }
    }
}
