package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查看事件告警规则的详情信息。 */
public class MonitorDescribeEventAlarmRuleApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorDescribeEventAlarmRuleApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v4/monitor/describe-event-alarm-rule",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public DescribeEventAlarmRuleResponse send(
            Credential credential, DescribeEventAlarmRuleRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionID != null) {
            ctReq.addParam("regionID", request.regionID);
            request.regionID = null;
        }
        if (request.alarmRuleID != null) {
            ctReq.addParam("alarmRuleID", request.alarmRuleID);
            request.alarmRuleID = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(DescribeEventAlarmRuleResponse.class);
    }

    public static class DescribeEventAlarmRuleRequest {
        /** 资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 告警规则ID */
        @JsonProperty("alarmRuleID")
        private String alarmRuleID;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getAlarmRuleID() {
            return this.alarmRuleID;
        }

        public void setAlarmRuleID(String alarmRuleID) {
            this.alarmRuleID = alarmRuleID;
        }
    }

    public static class DescribeEventAlarmRuleResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，一般为中文描述 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 失败时的错误描述，适配中英文 */
        @JsonProperty("description")
        private String description;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private DescribeEventAlarmRuleReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public DescribeEventAlarmRuleReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(DescribeEventAlarmRuleReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class DescribeEventAlarmRuleReturnObjResponse {
        /** 告警规则ID */
        @JsonProperty("alarmRuleID")
        private String alarmRuleID;

        /** ctyun资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /** 规则名 */
        @JsonProperty("name")
        private String name;

        /** 描述 */
        @JsonProperty("desc")
        private String desc;

        /**
         * 本参数表示服务。取值范围：<br>
         * ecs：云主机。<br>
         * evs：云硬盘。<br>
         * pms：物理机。<br>
         * ...<br>
         * 详见"[云监控：查询服务维度及监控项](https://www.ctyun.cn/document/10032263/10747790)"接口返回。
         */
        @JsonProperty("service")
        private String service;

        /**
         * 本参数表示告警维度。取值范围：<br>
         * ecs：云主机。<br>
         * disk：磁盘。<br>
         * pms：物理机。<br>
         * ...<br>
         * 详见"[云监控：查询服务维度及监控项](https://www.ctyun.cn/document/10032263/10747790)"接口返回。
         */
        @JsonProperty("dimension")
        private String dimension;

        /** 重复告警通知次数 */
        @JsonProperty("repeatTimes")
        private Integer repeatTimes;

        /** 告警接收策略静默时间，多久重复通知一次，单位为秒 */
        @JsonProperty("silenceTime")
        private Integer silenceTime;

        /**
         * 本参数表示恢复是否通知。取值范围：<br>
         * 0：否。<br>
         * 1：是。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("recoverNotify")
        private Integer recoverNotify;

        /**
         * 本参数表示告警接收策略。取值范围：<br>
         * email：邮件告警。<br>
         * sms：短信告警。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("notifyType")
        private List<String> notifyType;

        /** 告警联系人组 */
        @JsonProperty("contactGroupList")
        private List<DescribeEventAlarmRuleReturnObjContactGroupListResponse> contactGroupList;

        /**
         * 本参数表示通知周期。取值范围：<br>
         * 0：周日。<br>
         * 1：周一。<br>
         * 2：周二。<br>
         * 3：周三。<br>
         * 4：周四。<br>
         * 5：周五。<br>
         * 6：周六。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("notifyWeekdays")
        private List<Integer> notifyWeekdays;

        /** 通知起始时段，默认为00:00:00 */
        @JsonProperty("notifyStart")
        private String notifyStart;

        /** 通知结束时段，默认为23:59:59 */
        @JsonProperty("notifyEnd")
        private String notifyEnd;

        /** webhook消息推送url地址 */
        @JsonProperty("webhookUrl")
        private List<String> webhookUrl;

        /**
         * 本参数表示告警规则启用状态。取值范围：<br>
         * 0：启用。<br>
         * 1：停用。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("status")
        private Integer status;

        /**
         * 本参数表示告警规则告警状态。取值范围：<br>
         * 0：正常。<br>
         * 1：正在告警。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("alarmStatus")
        private Integer alarmStatus;

        /** 创建时间，毫秒级时间戳。 */
        @JsonProperty("createTime")
        private Integer createTime;

        /** 更新时间，毫秒级时间戳。 */
        @JsonProperty("updateTime")
        private Integer updateTime;

        /** 项目ID */
        @JsonProperty("projectID")
        private String projectID;

        /** 具体匹配策略 */
        @JsonProperty("conditions")
        private List<DescribeEventAlarmRuleReturnObjConditionsResponse> conditions;

        /** 资源信息列表 */
        @JsonProperty("resources")
        private List<DescribeEventAlarmRuleReturnObjResourcesResponse> resources;

        /**
         * 规则的资源范围，取值范围：<br>
         * 0：实例资源类型。<br>
         * 1：资源分组类型。<br>
         * 2：全部资源类型 。 <br>
         * 根据以上范围取值。
         */
        @JsonProperty("resourceScope")
        private Integer resourceScope;

        /**
         * 是否使用天翼云默认联系人接收通知，取值范围：<br>
         * 0：否。<br>
         * 1：是。 <br>
         * 根据以上范围取值。
         */
        @JsonProperty("defaultContact")
        private Integer defaultContact;

        public String getAlarmRuleID() {
            return this.alarmRuleID;
        }

        public void setAlarmRuleID(String alarmRuleID) {
            this.alarmRuleID = alarmRuleID;
        }

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public String getService() {
            return this.service;
        }

        public void setService(String service) {
            this.service = service;
        }

        public String getDimension() {
            return this.dimension;
        }

        public void setDimension(String dimension) {
            this.dimension = dimension;
        }

        public Integer getRepeatTimes() {
            return this.repeatTimes;
        }

        public void setRepeatTimes(Integer repeatTimes) {
            this.repeatTimes = repeatTimes;
        }

        public Integer getSilenceTime() {
            return this.silenceTime;
        }

        public void setSilenceTime(Integer silenceTime) {
            this.silenceTime = silenceTime;
        }

        public Integer getRecoverNotify() {
            return this.recoverNotify;
        }

        public void setRecoverNotify(Integer recoverNotify) {
            this.recoverNotify = recoverNotify;
        }

        public List<String> getNotifyType() {
            return this.notifyType;
        }

        public void setNotifyType(List<String> notifyType) {
            this.notifyType = notifyType;
        }

        public List<DescribeEventAlarmRuleReturnObjContactGroupListResponse> getContactGroupList() {
            return this.contactGroupList;
        }

        public void setContactGroupList(
                List<DescribeEventAlarmRuleReturnObjContactGroupListResponse> contactGroupList) {
            this.contactGroupList = contactGroupList;
        }

        public List<Integer> getNotifyWeekdays() {
            return this.notifyWeekdays;
        }

        public void setNotifyWeekdays(List<Integer> notifyWeekdays) {
            this.notifyWeekdays = notifyWeekdays;
        }

        public String getNotifyStart() {
            return this.notifyStart;
        }

        public void setNotifyStart(String notifyStart) {
            this.notifyStart = notifyStart;
        }

        public String getNotifyEnd() {
            return this.notifyEnd;
        }

        public void setNotifyEnd(String notifyEnd) {
            this.notifyEnd = notifyEnd;
        }

        public List<String> getWebhookUrl() {
            return this.webhookUrl;
        }

        public void setWebhookUrl(List<String> webhookUrl) {
            this.webhookUrl = webhookUrl;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public Integer getAlarmStatus() {
            return this.alarmStatus;
        }

        public void setAlarmStatus(Integer alarmStatus) {
            this.alarmStatus = alarmStatus;
        }

        public Integer getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(Integer createTime) {
            this.createTime = createTime;
        }

        public Integer getUpdateTime() {
            return this.updateTime;
        }

        public void setUpdateTime(Integer updateTime) {
            this.updateTime = updateTime;
        }

        public String getProjectID() {
            return this.projectID;
        }

        public void setProjectID(String projectID) {
            this.projectID = projectID;
        }

        public List<DescribeEventAlarmRuleReturnObjConditionsResponse> getConditions() {
            return this.conditions;
        }

        public void setConditions(
                List<DescribeEventAlarmRuleReturnObjConditionsResponse> conditions) {
            this.conditions = conditions;
        }

        public List<DescribeEventAlarmRuleReturnObjResourcesResponse> getResources() {
            return this.resources;
        }

        public void setResources(List<DescribeEventAlarmRuleReturnObjResourcesResponse> resources) {
            this.resources = resources;
        }

        public Integer getResourceScope() {
            return this.resourceScope;
        }

        public void setResourceScope(Integer resourceScope) {
            this.resourceScope = resourceScope;
        }

        public Integer getDefaultContact() {
            return this.defaultContact;
        }

        public void setDefaultContact(Integer defaultContact) {
            this.defaultContact = defaultContact;
        }
    }

    public static class DescribeEventAlarmRuleReturnObjContactGroupListResponse {
        /** 告警联系人组ID */
        @JsonProperty("contactGroupID")
        private String contactGroupID;

        /** 告警联系人组名称 */
        @JsonProperty("name")
        private String name;

        public String getContactGroupID() {
            return this.contactGroupID;
        }

        public void setContactGroupID(String contactGroupID) {
            this.contactGroupID = contactGroupID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static class DescribeEventAlarmRuleReturnObjConditionsResponse {
        /** 事件指标 */
        @JsonProperty("eventName")
        private String eventName;

        /** 事件中文描述 */
        @JsonProperty("description")
        private String description;

        /** 出现次数，告警阈值，整数格式字符串 */
        @JsonProperty("value")
        private String value;

        /** 本参数表示算法统计周期。 */
        @JsonProperty("period")
        private String period;

        /**
         * 告警等级。取值范围：<br>
         * 1：紧急。<br>
         * 2：警示。<br>
         * 3：普通。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("level")
        private Integer level;

        public String getEventName() {
            return this.eventName;
        }

        public void setEventName(String eventName) {
            this.eventName = eventName;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getPeriod() {
            return this.period;
        }

        public void setPeriod(String period) {
            this.period = period;
        }

        public Integer getLevel() {
            return this.level;
        }

        public void setLevel(Integer level) {
            this.level = level;
        }
    }

    public static class DescribeEventAlarmRuleReturnObjResourcesResponse {
        /** 资源信息 */
        @JsonProperty("resource")
        private List<DescribeEventAlarmRuleReturnObjResourcesResourceResponse> resource;

        public List<DescribeEventAlarmRuleReturnObjResourcesResourceResponse> getResource() {
            return this.resource;
        }

        public void setResource(
                List<DescribeEventAlarmRuleReturnObjResourcesResourceResponse> resource) {
            this.resource = resource;
        }
    }

    public static class DescribeEventAlarmRuleReturnObjResourcesResourceResponse {
        /** 资源实例标签键 */
        @JsonProperty("name")
        private String name;

        /** 资源实例标签值 */
        @JsonProperty("value")
        private String value;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}
