package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 调用此接口可查看通知模板详情。 */
public class MonitorDescribeNoticeTemplateApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorDescribeNoticeTemplateApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v4/monitor/describe-notice-template",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public DescribeNoticeTemplateResponse send(
            Credential credential, DescribeNoticeTemplateRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.noticeTemplateID != null) {
            ctReq.addParam("noticeTemplateID", request.noticeTemplateID);
            request.noticeTemplateID = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(DescribeNoticeTemplateResponse.class);
    }

    public static class DescribeNoticeTemplateRequest {
        /** 通知模板ID */
        @JsonProperty("noticeTemplateID")
        private String noticeTemplateID;

        public String getNoticeTemplateID() {
            return this.noticeTemplateID;
        }

        public void setNoticeTemplateID(String noticeTemplateID) {
            this.noticeTemplateID = noticeTemplateID;
        }
    }

    public static class DescribeNoticeTemplateResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，适配中英文 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 失败时的错误描述，适配中英文 */
        @JsonProperty("description")
        private String description;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        /** 返回参数 */
        @JsonProperty("returnObj")
        private DescribeNoticeTemplateReturnObjResponse returnObj;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public DescribeNoticeTemplateReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(DescribeNoticeTemplateReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }
    }

    public static class DescribeNoticeTemplateReturnObjResponse {
        /** 通知模板ID */
        @JsonProperty("noticeTemplateID")
        private String noticeTemplateID;

        /** 通知模板名称 */
        @JsonProperty("name")
        private String name;

        /** 服务 */
        @JsonProperty("service")
        private String service;

        /** 维度 */
        @JsonProperty("dimension")
        private String dimension;

        /** 通知模板 */
        @JsonProperty("contents")
        private List<DescribeNoticeTemplateReturnObjContentsResponse> contents;

        /** 是否为自定义默认通知模板 */
        @JsonProperty("isDefault")
        private Boolean isDefault;

        /** 创建时间，时间戳，精确到秒 */
        @JsonProperty("createTime")
        private Integer createTime;

        /** 最近更新时间，时间戳，精确到秒 */
        @JsonProperty("updateTime")
        private Integer updateTime;

        public String getNoticeTemplateID() {
            return this.noticeTemplateID;
        }

        public void setNoticeTemplateID(String noticeTemplateID) {
            this.noticeTemplateID = noticeTemplateID;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getService() {
            return this.service;
        }

        public void setService(String service) {
            this.service = service;
        }

        public String getDimension() {
            return this.dimension;
        }

        public void setDimension(String dimension) {
            this.dimension = dimension;
        }

        public List<DescribeNoticeTemplateReturnObjContentsResponse> getContents() {
            return this.contents;
        }

        public void setContents(List<DescribeNoticeTemplateReturnObjContentsResponse> contents) {
            this.contents = contents;
        }

        public Boolean getIsDefault() {
            return this.isDefault;
        }

        public void setIsDefault(Boolean isDefault) {
            this.isDefault = isDefault;
        }

        public Integer getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(Integer createTime) {
            this.createTime = createTime;
        }

        public Integer getUpdateTime() {
            return this.updateTime;
        }

        public void setUpdateTime(Integer updateTime) {
            this.updateTime = updateTime;
        }
    }

    public static class DescribeNoticeTemplateReturnObjContentsResponse {
        /** 通知模板内容 */
        @JsonProperty("content")
        private String content;

        /**
         * 本参数表示通知方式。取值范围：<br>
         * sms：短信。<br>
         * email：邮件。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("notifyType")
        private String notifyType;

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public String getNotifyType() {
            return this.notifyType;
        }

        public void setNotifyType(String notifyType) {
            this.notifyType = notifyType;
        }
    }
}
