package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 导出用户通知记录，导出格式为csv文件。 */
public class MonitorDownloadMessageRecordsApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorDownloadMessageRecordsApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v4/monitor/download-message-records",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public DownloadMessageRecordsResponse send(
            Credential credential, DownloadMessageRecordsRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(DownloadMessageRecordsResponse.class);
    }

    public static class DownloadMessageRecordsRequest {
        /** 创建通知起始时间，精确到毫秒 */
        @JsonProperty("startTime")
        private Long startTime;

        /** 创建通知截止时间，精确到毫秒（截止时间与起始时间间隔不超过30天） */
        @JsonProperty("endTime")
        private Long endTime;

        public Long getStartTime() {
            return this.startTime;
        }

        public void setStartTime(Long startTime) {
            this.startTime = startTime;
        }

        public Long getEndTime() {
            return this.endTime;
        }

        public void setEndTime(Long endTime) {
            this.endTime = endTime;
        }
    }

    public static class DownloadMessageRecordsResponse {}
}
