package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 导出指定条件的告警历史，导出格式为csv文件。 */
public class MonitorExportAlertHistoryApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorExportAlertHistoryApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v4/monitor/export-alert-history",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ExportAlertHistoryResponse send(Credential credential, ExportAlertHistoryRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ExportAlertHistoryResponse.class);
    }

    public static class ExportAlertHistoryRequest {
        /** ctyun资源池ID */
        @JsonProperty("regionID")
        private String regionID;

        /**
         * 本参数表示状态。取值范围：<br>
         * 0：正在告警。<br>
         * 1：告警历史。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("status")
        private Integer status;

        /** 资源分组ID。 */
        @JsonProperty("resourceGroupID")
        private String resourceGroupID;

        /**
         * 本参数表示搜索关键词。取值范围：<br>
         * alarmRuleID：告警规则ID，精确查询。<br>
         * name：告警规则名称，模糊查询。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("searchKey")
        private String searchKey;

        /** 配合searchKey使用，对应的值 */
        @JsonProperty("searchValue")
        private String searchValue;

        /**
         * 本参数表示告警服务。取值范围：<br>
         * ecs：云主机。<br>
         * evs：云硬盘。<br>
         * pms：物理机。<br>
         * ...<br>
         * 详见"[云监控：查询服务维度及监控项](https://www.ctyun.cn/document/10032263/10747790)"接口返回。
         */
        @JsonProperty("service")
        private List<String> service;

        /** 查询状态为告警历史（参数status=1）时的起始时间戳， 默认值：24小时前时间戳，startTime和endTime需同时传或同时不传 */
        @JsonProperty("startTime")
        private Integer startTime;

        /** 查询状态为告警历史（参数status=1）时的结束时间戳，默认值：当前时间戳， 配合startTime一起使用 */
        @JsonProperty("endTime")
        private Integer endTime;

        public String getRegionID() {
            return this.regionID;
        }

        public void setRegionID(String regionID) {
            this.regionID = regionID;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public String getResourceGroupID() {
            return this.resourceGroupID;
        }

        public void setResourceGroupID(String resourceGroupID) {
            this.resourceGroupID = resourceGroupID;
        }

        public String getSearchKey() {
            return this.searchKey;
        }

        public void setSearchKey(String searchKey) {
            this.searchKey = searchKey;
        }

        public String getSearchValue() {
            return this.searchValue;
        }

        public void setSearchValue(String searchValue) {
            this.searchValue = searchValue;
        }

        public List<String> getService() {
            return this.service;
        }

        public void setService(List<String> service) {
            this.service = service;
        }

        public Integer getStartTime() {
            return this.startTime;
        }

        public void setStartTime(Integer startTime) {
            this.startTime = startTime;
        }

        public Integer getEndTime() {
            return this.endTime;
        }

        public void setEndTime(Integer endTime) {
            this.endTime = endTime;
        }
    }

    public static class ExportAlertHistoryResponse {}
}
