package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 调用此接口可修改巡检项。 */
public class MonitorModifyInspectionItemApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public MonitorModifyInspectionItemApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v4/monitor/intelligent-inspection/modify-inspection-item",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ModifyInspectionItemResponse send(
            Credential credential, ModifyInspectionItemRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ModifyInspectionItemResponse.class);
    }

    public static class ModifyInspectionItemRequest {
        /**
         * 本参数表示巡检项。取值范围：<br>
         * 1：云主机性能评估。<br>
         * 2：监控数据健康评估。<br>
         * 3：云主机闲置资源检查。<br>
         * 4：云主机磁盘使用预警评估<br>
         * 根据以上范围取值。
         */
        @JsonProperty("inspectionItem")
        private Integer inspectionItem;

        /**
         * 本参数表示重要等级。取值范围：<br>
         * 1：低。<br>
         * 2：中。<br>
         * 3：高。<br>
         * 根据以上范围取值。
         */
        @JsonProperty("level")
        private Integer level;

        /** 巡检规则列表 */
        @JsonProperty("inspectionRules")
        private List<ModifyInspectionItemInspectionRulesRequest> inspectionRules;

        public Integer getInspectionItem() {
            return this.inspectionItem;
        }

        public void setInspectionItem(Integer inspectionItem) {
            this.inspectionItem = inspectionItem;
        }

        public Integer getLevel() {
            return this.level;
        }

        public void setLevel(Integer level) {
            this.level = level;
        }

        public List<ModifyInspectionItemInspectionRulesRequest> getInspectionRules() {
            return this.inspectionRules;
        }

        public void setInspectionRules(
                List<ModifyInspectionItemInspectionRulesRequest> inspectionRules) {
            this.inspectionRules = inspectionRules;
        }
    }

    public static class ModifyInspectionItemInspectionRulesRequest {
        /** 监控项，不同巡检项对应的监控项可根据巡检项查询接口获得。 */
        @JsonProperty("monitorItem")
        private String monitorItem;

        /** 巡检周期，在不同巡检项中对应巡检天数或预计未来天数 */
        @JsonProperty("period")
        private Integer period;

        /** 阈值 */
        @JsonProperty("monitorValue")
        private Double monitorValue;

        public String getMonitorItem() {
            return this.monitorItem;
        }

        public void setMonitorItem(String monitorItem) {
            this.monitorItem = monitorItem;
        }

        public Integer getPeriod() {
            return this.period;
        }

        public void setPeriod(Integer period) {
            this.period = period;
        }

        public Double getMonitorValue() {
            return this.monitorValue;
        }

        public void setMonitorValue(Double monitorValue) {
            this.monitorValue = monitorValue;
        }
    }

    public static class ModifyInspectionItemResponse {
        /** 返回状态码（800为成功，900为失败），默认值：800 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 失败时的错误代码，参见公共错误码说明 */
        @JsonProperty("errorCode")
        private String errorCode;

        /** 失败时的错误描述，一般为英文描述 */
        @JsonProperty("message")
        private String message;

        /** 失败时的错误描述，一般为中文描述 */
        @JsonProperty("msgDesc")
        private String msgDesc;

        /** 返回参数，参考returnObj对象结构 */
        @JsonProperty("returnObj")
        private ModifyInspectionItemReturnObjResponse returnObj;

        /** 错误码，请求成功时，不返回该字段 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getMsgDesc() {
            return this.msgDesc;
        }

        public void setMsgDesc(String msgDesc) {
            this.msgDesc = msgDesc;
        }

        public ModifyInspectionItemReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(ModifyInspectionItemReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class ModifyInspectionItemReturnObjResponse {
        /** 修改成功标识 */
        @JsonProperty("success")
        private Boolean success;

        public Boolean getSuccess() {
            return this.success;
        }

        public void setSuccess(Boolean success) {
            this.success = success;
        }
    }
}
